/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.gson;

import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.json.gson.GsonXMLStreamReader;

public class JsonBuilder
implements Builder {
    @Override
    public OMElement processDocument(InputStream inputStream, String s, MessageContext messageContext) throws AxisFault {
        messageContext.setProperty("isJsonStream", true);
        String charSetEncoding = null;
        try {
            charSetEncoding = (String)messageContext.getProperty("CHARACTER_SET_ENCODING");
            JsonReader jsonReader = new JsonReader(new InputStreamReader(inputStream, charSetEncoding));
            GsonXMLStreamReader gsonXMLStreamReader = new GsonXMLStreamReader(jsonReader);
            messageContext.setProperty("GsonXMLStreamReader", gsonXMLStreamReader);
            SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
            return soapFactory.getDefaultEnvelope();
        }
        catch (UnsupportedEncodingException e) {
            throw new AxisFault(charSetEncoding + " encoding is may not supported by json inputStream ", e);
        }
    }
}

