/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.mex.om;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.mex.MexException;
import org.apache.axis2.mex.om.IMexOM;
import org.apache.axis2.mex.om.Location;
import org.apache.axis2.mex.om.MetadataReference;
import org.apache.axis2.mex.om.MexOM;
import org.apache.axis2.mex.om.MexOMException;
import org.apache.axis2.mex.util.MexUtil;

public class MetadataSection
extends MexOM
implements IMexOM {
    private String namespaceValue = null;
    private OMFactory factory;
    private String anyAttribute = null;
    private OMNode inlineData = null;
    private Location location = null;
    private MetadataReference ref = null;
    private String dialect;
    private String identifier;

    public MetadataSection() throws MexException {
        this.factory = MexUtil.getSOAPFactory("http://www.w3.org/2003/05/soap-envelope");
        this.namespaceValue = "http://schemas.xmlsoap.org/ws/2004/09/mex";
    }

    public MetadataSection(OMFactory defaultFactory, String namespaceValue) throws MexOMException {
        this.factory = defaultFactory;
        this.namespaceValue = namespaceValue;
    }

    public MetadataSection fromOM(OMElement element) throws MexOMException {
        if (element == null) {
            throw new MexOMException("Null element passed.");
        }
        if (!element.getLocalName().equals("MetadataSection")) {
            throw new MexOMException("Invalid element passed.");
        }
        OMAttribute dialectAttr = element.getAttribute(new QName("Dialect"));
        if (dialectAttr == null) {
            throw new MexOMException("Missing Dialect Attribute in MetadataSection.");
        }
        this.setDialect(dialectAttr.getAttributeValue());
        OMAttribute identifierAttr = element.getAttribute(new QName("Identifier"));
        if (identifierAttr != null) {
            this.setIdentifier(identifierAttr.getAttributeValue());
        }
        OMElement locationElem = element.getFirstChildWithName(new QName(this.namespaceValue, "Location"));
        Location location = null;
        MetadataReference ref = null;
        if (locationElem != null) {
            location = new Location(this.factory, this.namespaceValue);
            this.setLocation(location.fromOM(locationElem));
        } else {
            OMElement refElem = element.getFirstChildWithName(new QName(this.namespaceValue, "MetadataReference"));
            if (refElem != null) {
                ref = new MetadataReference(this.factory, this.namespaceValue);
                this.setMetadataReference(ref.fromOM(refElem));
            }
        }
        if (location == null && ref == null) {
            OMNode inline = element.getFirstOMChild();
            if (inline != null) {
                this.setinlineData(inline);
            } else {
                throw new MexOMException("Invalid empty MetadataSection.");
            }
        }
        return this;
    }

    @Override
    public OMElement toOM() throws MexOMException {
        OMNamespace mexNamespace = this.factory.createOMNamespace(this.namespaceValue, "mex");
        OMElement metadataSection = this.factory.createOMElement("MetadataSection", mexNamespace);
        if (this.dialect == null) {
            throw new MexOMException("Dialet was not set. Dialet must be set.");
        }
        OMAttribute dialetAttrib = this.factory.createOMAttribute("Dialect", null, this.dialect);
        metadataSection.addAttribute(dialetAttrib);
        if (this.identifier != null && this.identifier.trim().length() > 0) {
            OMAttribute identifierAttrib = this.factory.createOMAttribute("Identifier", null, this.identifier);
            metadataSection.addAttribute(identifierAttrib);
        }
        if (this.anyAttribute != null) {
            OMAttribute anyAttrib = this.factory.createOMAttribute("AnyAttribute", null, this.anyAttribute);
            metadataSection.addAttribute(anyAttrib);
        }
        if (this.inlineData != null) {
            metadataSection.addChild(this.inlineData);
        }
        if (this.location != null) {
            metadataSection.addChild(this.location.toOM());
        }
        if (this.ref != null) {
            metadataSection.addChild(this.ref.toOM());
        }
        return metadataSection;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getanyAttribute() {
        return this.anyAttribute;
    }

    public Location getLocation() {
        return this.location;
    }

    public OMNode getInlineData() {
        return this.inlineData;
    }

    public MetadataReference getMetadataReference() {
        return this.ref;
    }

    public void setIdentifier(String in_identifier) {
        this.identifier = in_identifier;
    }

    public void setDialect(String in_dialect) {
        this.dialect = in_dialect;
    }

    public void setLocation(Location in_location) {
        this.location = in_location;
    }

    public void setinlineData(Object in_inlineData) {
        this.inlineData = (OMNode)in_inlineData;
    }

    public void setMetadataReference(MetadataReference in_ref) {
        this.ref = in_ref;
    }
}

