/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.WeakHashMap;
import javax.activation.DataSource;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;

public class SAAJDataSource
implements DataSource {
    protected String contentType = "application/octet-stream";
    private InputStream ss;
    public static final int MIN_MEMORY_DISK_CACHED = -1;
    public static final int MAX_MEMORY_DISK_CACHED = 16384;
    protected int maxCached = 16384;
    protected File diskCacheFile = null;
    protected WeakHashMap readers = new WeakHashMap();
    protected boolean deleted;
    public static final int READ_CHUNK_SZ = 32768;
    protected LinkedList memorybuflist = new LinkedList();
    protected byte[] currentMemoryBuf = null;
    protected int currentMemoryBufSz;
    protected long totalsz;
    protected BufferedOutputStream cachediskstream;
    protected boolean closed = false;

    protected SAAJDataSource() {
    }

    public SAAJDataSource(InputStream ss, int maxCached, String contentType) throws IOException {
        this(ss, maxCached, contentType, false);
    }

    public SAAJDataSource(InputStream ss, int maxCached, String contentType, boolean readall) throws IOException {
        this.ss = ss instanceof BufferedInputStream ? ss : new BufferedInputStream(ss);
        this.maxCached = maxCached;
        if (null != contentType && contentType.length() != 0) {
            this.contentType = contentType;
        }
        if (maxCached < -1) {
            throw new IllegalArgumentException("badMaxCached " + maxCached);
        }
        if (readall) {
            byte[] readbuffer = new byte[32768];
            int read = 0;
            do {
                if ((read = ss.read(readbuffer)) <= 0) continue;
                this.writeToMemory(readbuffer, read);
            } while (read > -1);
            this.close();
        }
    }

    protected synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (null != this.cachediskstream) {
                this.cachediskstream.close();
                this.cachediskstream = null;
            }
            if (null != this.memorybuflist) {
                if (this.currentMemoryBufSz > 0) {
                    byte[] tmp = new byte[this.currentMemoryBufSz];
                    System.arraycopy(this.currentMemoryBuf, 0, tmp, 0, this.currentMemoryBufSz);
                    this.memorybuflist.set(this.memorybuflist.size() - 1, tmp);
                }
                this.currentMemoryBuf = null;
            }
        }
    }

    protected void flushToDisk() throws IOException, FileNotFoundException {
        LinkedList ml = this.memorybuflist;
        if (ml != null && null == this.cachediskstream) {
            try {
                Parameter param;
                MessageContext messageContext = MessageContext.getCurrentMessageContext();
                String attachementDir = "";
                attachementDir = (String)messageContext.getProperty("attachmentDIR");
                if (attachementDir.equals("") && (param = messageContext.getParameter("attachmentDIR")) != null) {
                    attachementDir = (String)param.getValue();
                }
                this.diskCacheFile = File.createTempFile("Axis", ".att", attachementDir == null ? null : new File(attachementDir));
                this.cachediskstream = new BufferedOutputStream(new FileOutputStream(this.diskCacheFile));
                int listsz = ml.size();
                for (byte[] rbuf : ml) {
                    int bwrite = listsz-- == 0 ? this.currentMemoryBufSz : rbuf.length;
                    this.cachediskstream.write(rbuf, 0, bwrite);
                    if (!this.closed) continue;
                    this.cachediskstream.close();
                    this.cachediskstream = null;
                }
                this.memorybuflist = null;
            }
            catch (SecurityException se) {
                this.diskCacheFile = null;
                this.cachediskstream = null;
                this.maxCached = Integer.MAX_VALUE;
            }
        }
    }

    protected void write(byte[] data) throws IOException {
        this.write(data, data.length);
    }

    protected synchronized void write(byte[] data, int length) throws IOException {
        if (this.closed) {
            throw new IOException("streamClosed");
        }
        int byteswritten = 0;
        if (null != this.memorybuflist && this.totalsz + (long)length > (long)this.maxCached && null == this.cachediskstream) {
            this.flushToDisk();
        }
        if (this.memorybuflist != null) {
            do {
                if (null == this.currentMemoryBuf) {
                    this.currentMemoryBuf = new byte[32768];
                    this.currentMemoryBufSz = 0;
                    this.memorybuflist.add(this.currentMemoryBuf);
                }
                int bytes2write = Math.min(length - byteswritten, this.currentMemoryBuf.length - this.currentMemoryBufSz);
                System.arraycopy(data, byteswritten, this.currentMemoryBuf, this.currentMemoryBufSz, bytes2write);
                this.currentMemoryBufSz += bytes2write;
                if ((byteswritten += bytes2write) >= length) continue;
                this.currentMemoryBuf = new byte[32768];
                this.currentMemoryBufSz = 0;
                this.memorybuflist.add(this.currentMemoryBuf);
            } while (byteswritten < length);
        }
        if (null != this.cachediskstream) {
            this.cachediskstream.write(data, 0, length);
        }
        this.totalsz += (long)length;
    }

    protected synchronized void writeToMemory(byte[] data, int length) throws IOException {
        if (this.closed) {
            throw new IOException("streamClosed");
        }
        int byteswritten = 0;
        if (this.memorybuflist != null) {
            do {
                if (null == this.currentMemoryBuf) {
                    this.currentMemoryBuf = new byte[32768];
                    this.currentMemoryBufSz = 0;
                    this.memorybuflist.add(this.currentMemoryBuf);
                }
                int bytes2write = Math.min(length - byteswritten, this.currentMemoryBuf.length - this.currentMemoryBufSz);
                System.arraycopy(data, byteswritten, this.currentMemoryBuf, this.currentMemoryBufSz, bytes2write);
                this.currentMemoryBufSz += bytes2write;
                if ((byteswritten += bytes2write) >= length) continue;
                this.currentMemoryBuf = new byte[32768];
                this.currentMemoryBufSz = 0;
                this.memorybuflist.add(this.currentMemoryBuf);
            } while (byteswritten < length);
        }
        this.totalsz += (long)length;
    }

    public File getDiskCacheFile() {
        return this.diskCacheFile;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new SAAJInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getName() {
        String ret = null;
        try {
            this.flushToDisk();
            if (this.diskCacheFile != null) {
                ret = this.diskCacheFile.getAbsolutePath();
            }
        }
        catch (Exception e) {
            this.diskCacheFile = null;
        }
        return ret;
    }

    private class SAAJInputStream
    extends InputStream {
        protected long bread = 0L;
        private FileInputStream fileIS;
        int currentIndex;
        byte[] currentBuf;
        int currentBufPos;
        boolean readClosed;

        protected SAAJInputStream() throws IOException {
            if (SAAJDataSource.this.deleted) {
                throw new IOException("resourceDeleted");
            }
            SAAJDataSource.this.readers.put(this, null);
        }

        @Override
        public int available() throws IOException {
            if (SAAJDataSource.this.deleted) {
                throw new IOException("resourceDeleted");
            }
            if (this.readClosed) {
                throw new IOException("streamClosed");
            }
            return new Long(Math.min(Integer.MAX_VALUE, SAAJDataSource.this.totalsz - this.bread)).intValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            SAAJDataSource sAAJDataSource = SAAJDataSource.this;
            synchronized (sAAJDataSource) {
                byte[] retb = new byte[1];
                int br = this.read(retb, 0, 1);
                if (br == -1) {
                    return -1;
                }
                return 0xFF & retb[0];
            }
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("noResetMark");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long skipped) throws IOException {
            if (SAAJDataSource.this.deleted) {
                throw new IOException("resourceDeleted");
            }
            if (this.readClosed) {
                throw new IOException("streamClosed");
            }
            if (skipped < 1L) {
                return 0L;
            }
            SAAJDataSource sAAJDataSource = SAAJDataSource.this;
            synchronized (sAAJDataSource) {
                skipped = Math.min(skipped, SAAJDataSource.this.totalsz - this.bread);
                if (skipped == 0L) {
                    return 0L;
                }
                LinkedList ml = SAAJDataSource.this.memorybuflist;
                int bwritten = 0;
                if (ml != null) {
                    if (null == this.currentBuf) {
                        this.currentBuf = (byte[])ml.get(this.currentIndex);
                        this.currentBufPos = 0;
                    }
                    do {
                        long bcopy = Math.min((long)(this.currentBuf.length - this.currentBufPos), skipped - (long)bwritten);
                        bwritten = (int)((long)bwritten + bcopy);
                        this.currentBufPos = (int)((long)this.currentBufPos + bcopy);
                        if ((long)bwritten >= skipped) continue;
                        this.currentBuf = (byte[])ml.get(++this.currentIndex);
                        this.currentBufPos = 0;
                    } while ((long)bwritten < skipped);
                }
                if (null != this.fileIS) {
                    this.fileIS.skip(skipped);
                }
                this.bread += skipped;
            }
            return skipped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (SAAJDataSource.this.deleted) {
                throw new IOException("resourceDeleted");
            }
            if (this.readClosed) {
                throw new IOException("streamClosed");
            }
            if (b == null) {
                throw new RuntimeException("nullInput");
            }
            if (off < 0) {
                throw new IndexOutOfBoundsException("negOffset " + off);
            }
            if (len < 0) {
                throw new IndexOutOfBoundsException("length " + len);
            }
            if (len + off > b.length) {
                throw new IndexOutOfBoundsException("writeBeyond");
            }
            if (len == 0) {
                return 0;
            }
            int bwritten = 0;
            SAAJDataSource sAAJDataSource = SAAJDataSource.this;
            synchronized (sAAJDataSource) {
                if (this.bread == SAAJDataSource.this.totalsz) {
                    return -1;
                }
                LinkedList ml = SAAJDataSource.this.memorybuflist;
                long longlen = len;
                longlen = Math.min(longlen, SAAJDataSource.this.totalsz - this.bread);
                len = new Long(longlen).intValue();
                if (ml != null) {
                    if (null == this.currentBuf) {
                        this.currentBuf = (byte[])ml.get(this.currentIndex);
                        this.currentBufPos = 0;
                    }
                    do {
                        int bcopy = Math.min(this.currentBuf.length - this.currentBufPos, len - bwritten);
                        System.arraycopy(this.currentBuf, this.currentBufPos, b, off + bwritten, bcopy);
                        this.currentBufPos += bcopy;
                        if ((bwritten += bcopy) >= len) continue;
                        this.currentBuf = (byte[])ml.get(++this.currentIndex);
                        this.currentBufPos = 0;
                    } while (bwritten < len);
                }
                if (bwritten == 0 && null != SAAJDataSource.this.diskCacheFile) {
                    if (null == this.fileIS) {
                        this.fileIS = new FileInputStream(SAAJDataSource.this.diskCacheFile);
                        if (this.bread > 0L) {
                            this.fileIS.skip(this.bread);
                        }
                    }
                    if (SAAJDataSource.this.cachediskstream != null) {
                        SAAJDataSource.this.cachediskstream.flush();
                    }
                    bwritten = this.fileIS.read(b, off, len);
                }
                if (bwritten > 0) {
                    this.bread += (long)bwritten;
                }
            }
            return bwritten;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.readClosed) {
                SAAJDataSource.this.readers.remove(this);
                this.readClosed = true;
                if (this.fileIS != null) {
                    this.fileIS.close();
                }
                this.fileIS = null;
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.close();
        }
    }
}

