/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompiler;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Document;

public class XSD2Java {
    private static Options options;
    private static CommandLine line;

    public static void main(String[] args) throws Exception {
        options = new Options();
        OptionBuilder.withArgName(SchemaCompilerMessages.getMessage("schema.ns2p.argname"));
        OptionBuilder.hasArgs(2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription(SchemaCompilerMessages.getMessage("schema.ns2p.description"));
        options.addOption(OptionBuilder.create("ns2p"));
        OptionBuilder.withArgName(SchemaCompilerMessages.getMessage("schema.mp.argname"));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(SchemaCompilerMessages.getMessage("schema.mp.description"));
        options.addOption(OptionBuilder.create("mp"));
        OptionBuilder.withArgName(SchemaCompilerMessages.getMessage("schema.dp.argname"));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(SchemaCompilerMessages.getMessage("schema.dp.description"));
        options.addOption(OptionBuilder.create("dp"));
        OptionBuilder.withDescription(SchemaCompilerMessages.getMessage("schema.h.description"));
        options.addOption(OptionBuilder.create("h"));
        OptionBuilder.withArgName(SchemaCompilerMessages.getMessage("schema.p.argname"));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(SchemaCompilerMessages.getMessage("schema.p.description"));
        options.addOption(OptionBuilder.create("p"));
        GnuParser parser = new GnuParser();
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException ex) {
            System.out.println(ex.getLocalizedMessage());
            System.out.println();
            XSD2Java.printUsage();
            System.out.println(ex);
            System.exit(1);
        }
        args = line.getArgs();
        if (args.length < 2) {
            XSD2Java.printUsage();
            System.exit(1);
        } else {
            File outputFolder = new File(args[args.length - 1]);
            for (int i = 0; i < args.length - 1; ++i) {
                File xsdFile = new File(args[i]);
                if (args.length > 2) {
                    System.out.println(SchemaCompilerMessages.getMessage("schema.compiling", xsdFile.getName()));
                }
                XSD2Java.compile(xsdFile, outputFolder);
            }
        }
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(SchemaCompilerMessages.getMessage("schema.usage"), options);
    }

    private static void compile(File xsdFile, File outputFolder) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
        Document doc = builder.parse(xsdFile);
        XmlSchemaCollection schemaCol = new XmlSchemaCollection();
        XmlSchema currentSchema = schemaCol.read(doc, xsdFile.toURI().toString(), null);
        if (outputFolder.exists()) {
            if (outputFolder.isFile()) {
                throw new IOException(SchemaCompilerMessages.getMessage("schema.locationNotFolder"));
            }
        } else {
            outputFolder.mkdirs();
        }
        CompilerOptions compilerOptions = new CompilerOptions();
        compilerOptions.setOutputLocation(outputFolder);
        compilerOptions.setGenerateAll(true);
        HashMap<String, String> ns2p = new HashMap<String, String>();
        if (line.hasOption("ns2p")) {
            ns2p.putAll(line.getOptionProperties("ns2p"));
        }
        if (line.hasOption("dp")) {
            ns2p.put("", line.getOptionValue("dp"));
        }
        if (!ns2p.isEmpty()) {
            compilerOptions.setNs2PackageMap(ns2p);
        }
        if (line.hasOption("mp")) {
            compilerOptions.setMapperClassPackage(line.getOptionValue("mp"));
        }
        compilerOptions.setHelperMode(line.hasOption("h"));
        if (line.hasOption("p")) {
            compilerOptions.setPackageName(line.getOptionValue("p"));
        }
        compilerOptions.setWrapClasses(false);
        compilerOptions.setWriteOutput(true);
        SchemaCompiler compiler = new SchemaCompiler(compilerOptions);
        compiler.compile(currentSchema);
    }
}

