/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.format.BinaryFormatter;
import org.apache.axis2.format.PlainTextFormatter;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.axis2.transport.base.BaseTransportException;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseUtils {
    private static final Log log = LogFactory.getLog(BaseUtils.class);

    public static QName getQNameFromString(Object obj) {
        if (obj instanceof QName) {
            return (QName)obj;
        }
        String value = obj.toString();
        int open = value.indexOf(123);
        int close = value.indexOf(125);
        if (close > open && open > -1 && value.length() > close) {
            return new QName(value.substring(open + 1, close - open), value.substring(close + 1));
        }
        return new QName(value);
    }

    public static void markServiceAsFaulty(String serviceName, String msg, AxisConfiguration axisCfg) {
        if (serviceName != null) {
            try {
                AxisService service = axisCfg.getService(serviceName);
                if (service != null) {
                    axisCfg.getFaultyServices().put(service.getName(), msg);
                }
            }
            catch (AxisFault axisFault) {
                log.warn("Error marking service : " + serviceName + " as faulty", axisFault);
            }
        }
    }

    public static SOAPEnvelope getEnvelope(InputStream in, String namespace) throws XMLStreamException {
        try {
            in.reset();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader(in, "UTF-8");
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlreader, namespace);
        return (SOAPEnvelope)builder.getDocumentElement();
    }

    public static OMOutputFormat getOMOutputFormat(MessageContext msgContext) {
        OMOutputFormat format = new OMOutputFormat();
        msgContext.setDoingMTOM(TransportUtils.doWriteMTOM(msgContext));
        msgContext.setDoingSwA(TransportUtils.doWriteSwA(msgContext));
        msgContext.setDoingREST(TransportUtils.isDoingREST(msgContext));
        format.setSOAP11(msgContext.isSOAP11());
        format.setDoOptimize(msgContext.isDoingMTOM());
        format.setDoingSWA(msgContext.isDoingSwA());
        format.setCharSetEncoding(TransportUtils.getCharSetEncoding(msgContext));
        Object mimeBoundaryProperty = msgContext.getProperty("mimeBoundary");
        if (mimeBoundaryProperty != null) {
            format.setMimeBoundary((String)mimeBoundaryProperty);
        }
        return format;
    }

    public static MessageFormatter getMessageFormatter(MessageContext msgContext) {
        OMElement firstChild = msgContext.getEnvelope().getBody().getFirstElement();
        if (firstChild != null) {
            if (BaseConstants.DEFAULT_BINARY_WRAPPER.equals(firstChild.getQName())) {
                return new BinaryFormatter();
            }
            if (BaseConstants.DEFAULT_TEXT_WRAPPER.equals(firstChild.getQName())) {
                return new PlainTextFormatter();
            }
        }
        try {
            return MessageProcessorSelector.getMessageFormatter(msgContext);
        }
        catch (AxisFault axisFault) {
            throw new BaseTransportException("Unable to get the message formatter to use");
        }
    }

    protected static void handleException(String s) {
        log.error(s);
        throw new BaseTransportException(s);
    }

    protected static void handleException(String s, Exception e) {
        log.error(s, e);
        throw new BaseTransportException(s, e);
    }

    public static boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUsingTransport(AxisService service, String transportName) {
        boolean process = service.isEnableAllTransports();
        if (process) {
            return true;
        }
        List<String> transports = service.getExposedTransports();
        for (String transport : transports) {
            if (!transportName.equals(transport)) continue;
            return true;
        }
        return false;
    }

    public static Hashtable<String, String> getEPRProperties(String url) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        int propPos = url.indexOf("?");
        if (propPos != -1) {
            StringTokenizer st = new StringTokenizer(url.substring(propPos + 1), "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int sep = token.indexOf("=");
                if (sep == -1) continue;
                h.put(token.substring(0, sep), token.substring(sep + 1));
            }
        }
        return h;
    }

    public static Properties loadProperties(String filePath) {
        InputStream in;
        Properties properties = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (log.isDebugEnabled()) {
            log.debug("Loading a file '" + filePath + "' from classpath");
        }
        if ((in = cl.getResourceAsStream(filePath)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to load file  '" + filePath + "'");
            }
            filePath = "conf" + File.separatorChar + filePath;
            if (log.isDebugEnabled()) {
                log.debug("Loading a file '" + filePath + "' from classpath");
            }
            if ((in = cl.getResourceAsStream(filePath)) == null && log.isDebugEnabled()) {
                log.debug("Unable to load file  ' " + filePath + " '");
            }
        }
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (IOException e) {
                String msg = "Error loading properties from a file at :" + filePath;
                log.error(msg, e);
                throw new BaseTransportException(msg, e);
            }
        }
        return properties;
    }
}

