/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.httpclient.methods.RequestEntity;

public class RESTRequestEntity
implements RequestEntity {
    private byte[] bytes;
    private String charSetEnc;
    private boolean chunked;
    private OMElement element;
    private MessageContext msgCtxt;
    private String soapActionString;
    private OMOutputFormat format;

    public RESTRequestEntity(OMElement element, boolean chunked, MessageContext msgCtxt, String charSetEncoding, String soapActionString, OMOutputFormat format) {
        this.element = element;
        this.chunked = chunked;
        this.msgCtxt = msgCtxt;
        this.charSetEnc = charSetEncoding;
        this.soapActionString = soapActionString;
        this.format = format;
    }

    private void handleOMOutput(OutputStream out, boolean doingMTOM) throws XMLStreamException {
        this.format.setDoOptimize(doingMTOM);
        this.element.serializeAndConsume(out, this.format);
    }

    public byte[] writeBytes() throws AxisFault {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            if (!this.format.isOptimized()) {
                OMOutputFormat format2 = new OMOutputFormat();
                format2.setCharSetEncoding(this.charSetEnc);
                this.element.serializeAndConsume(bytesOut, format2);
                return bytesOut.toByteArray();
            }
            this.format.setCharSetEncoding(this.charSetEnc);
            this.format.setDoOptimize(true);
            this.element.serializeAndConsume(bytesOut, this.format);
            return bytesOut.toByteArray();
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault(e);
        }
        catch (FactoryConfigurationError e) {
            throw AxisFault.makeFault(e);
        }
    }

    @Override
    public void writeRequest(OutputStream out) throws IOException {
        try {
            if (this.chunked) {
                this.handleOMOutput(out, this.format.isDoingSWA());
            } else {
                if (this.bytes == null) {
                    this.bytes = this.writeBytes();
                }
                out.write(this.bytes);
            }
            out.flush();
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault(e);
        }
        catch (FactoryConfigurationError e) {
            throw AxisFault.makeFault(e);
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
    }

    @Override
    public long getContentLength() {
        try {
            if (this.chunked) {
                return -1L;
            }
            if (this.bytes == null) {
                this.bytes = this.writeBytes();
            }
            return this.bytes.length;
        }
        catch (AxisFault e) {
            return -1L;
        }
    }

    @Override
    public String getContentType() {
        String encoding = this.format.getCharSetEncoding();
        String contentType = this.format.getContentType();
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (!(this.msgCtxt.isSOAP11() || this.soapActionString == null || "".equals(this.soapActionString.trim()) || "\"\"".equals(this.soapActionString.trim()))) {
            contentType = contentType + ";action=\"" + this.soapActionString + "\";";
        }
        return contentType;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }
}

