/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.io.Writer;
import org.apache.commons.logging.Log;

public class LogWriter
extends Writer {
    private final Log log;
    private final String endOfLine;
    private final StringBuffer lineBuffer = new StringBuffer();
    private int endOfLineMatch;

    public LogWriter(Log log, String endOfLine) {
        this.log = log;
        this.endOfLine = endOfLine;
    }

    public LogWriter(Log log) {
        this(log, System.getProperty("line.separator"));
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        int start = off;
        for (int i = off; i < off + len; ++i) {
            if (cbuf[i] == this.endOfLine.charAt(this.endOfLineMatch)) {
                ++this.endOfLineMatch;
                if (this.endOfLineMatch != this.endOfLine.length()) continue;
                this.lineBuffer.append(cbuf, start, i - start + 1);
                this.lineBuffer.setLength(this.lineBuffer.length() - this.endOfLine.length());
                this.flushLineBuffer();
                start = i + 1;
                this.endOfLineMatch = 0;
                continue;
            }
            this.endOfLineMatch = 0;
        }
        this.lineBuffer.append(cbuf, start, off + len - start);
    }

    @Override
    public void close() {
        if (this.lineBuffer.length() > 0) {
            this.flushLineBuffer();
        }
    }

    @Override
    public void flush() {
    }

    private void flushLineBuffer() {
        this.log.info(this.lineBuffer.toString());
        this.lineBuffer.setLength(0);
    }
}

