/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.AbstractPollTableEntry;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.axis2.transport.mail.MailUtils;
import org.apache.commons.logging.Log;

public class PollTableEntry
extends AbstractPollTableEntry {
    private final Log log;
    public static final int DELETE = 0;
    public static final int MOVE = 1;
    private InternetAddress emailAddress = null;
    private String userName = null;
    private String password = null;
    private String protocol = null;
    private Session session;
    private String folder;
    private String xServicePath;
    private String contentType;
    private InternetAddress replyAddress = null;
    private List<String> preserveHeaders = null;
    private List<String> removeHeaders = null;
    private int actionAfterProcess = 0;
    private int actionAfterFailure = 0;
    private String moveAfterProcess;
    private String moveAfterFailure;
    private boolean processingMailInParallel = false;
    private List<String> uidList = Collections.synchronizedList(new ArrayList());
    private int maxRetryCount;
    private long reconnectTimeout;

    public PollTableEntry(Log log) {
        this.log = log;
    }

    @Override
    public EndpointReference[] getEndpointReferences(AxisService service, String ip) {
        return new EndpointReference[]{new EndpointReference("mailto:" + this.emailAddress)};
    }

    public InternetAddress getEmailAddress() {
        return this.emailAddress;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getXServicePath() {
        return this.xServicePath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getActionAfterProcess() {
        return this.actionAfterProcess;
    }

    public int getActionAfterFailure() {
        return this.actionAfterFailure;
    }

    public String getMoveAfterProcess() {
        return this.moveAfterProcess;
    }

    public String getMoveAfterFailure() {
        return this.moveAfterFailure;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public long getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public String getFolder() {
        return this.folder;
    }

    public InternetAddress getReplyAddress() {
        return this.replyAddress;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Session getSession() {
        return this.session;
    }

    private void addPreserveHeaders(String headerList) {
        if (headerList == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(headerList, " ,");
        this.preserveHeaders = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 0) continue;
            this.preserveHeaders.add(token);
        }
    }

    private void addRemoveHeaders(String headerList) {
        if (headerList == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(headerList, " ,");
        this.removeHeaders = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 0) continue;
            this.removeHeaders.add(token);
        }
    }

    public boolean retainHeader(String name) {
        if (this.preserveHeaders != null) {
            return this.preserveHeaders.contains(name);
        }
        if (this.removeHeaders != null) {
            return !this.removeHeaders.contains(name);
        }
        return true;
    }

    public boolean isProcessingMailInParallel() {
        return this.processingMailInParallel;
    }

    @Override
    public boolean loadConfiguration(ParameterInclude paramIncl) throws AxisFault {
        String strReconnectTimeout;
        String strMaxRetryCount;
        String pollInParallel;
        String address = ParamUtils.getOptionalParam(paramIncl, "transport.mail.Address");
        if (address == null) {
            return false;
        }
        try {
            this.emailAddress = new InternetAddress(address);
        }
        catch (AddressException e) {
            throw new AxisFault("Invalid email address specified by 'transport.mail.Address' parameter :: " + e.getMessage());
        }
        ArrayList<Parameter> params = paramIncl.getParameters();
        Properties props = new Properties();
        for (Parameter p : params) {
            if (p.getName().startsWith("mail.")) {
                props.setProperty(p.getName(), (String)p.getValue());
            }
            if ("mail.pop3.user".equals(p.getName()) || "mail.imap.user".equals(p.getName())) {
                this.userName = (String)p.getValue();
            }
            if ("mail.pop3.password".equals(p.getName()) || "mail.imap.password".equals(p.getName())) {
                this.password = (String)p.getValue();
            }
            if (!"transport.mail.Protocol".equals(p.getName())) continue;
            this.protocol = (String)p.getValue();
        }
        this.session = Session.getInstance(props, null);
        MailUtils.setupLogging(this.session, this.log, paramIncl);
        this.contentType = ParamUtils.getOptionalParam(paramIncl, "transport.mail.ContentType");
        try {
            String replyAddress = ParamUtils.getOptionalParam(paramIncl, "transport.mail.ReplyAddress");
            if (replyAddress != null) {
                this.replyAddress = new InternetAddress(replyAddress);
            }
        }
        catch (AddressException e) {
            throw new AxisFault("Invalid email address specified by 'transport.mail.ReplyAddress' parameter :: " + e.getMessage());
        }
        this.folder = ParamUtils.getOptionalParam(paramIncl, "transport.mail.Folder");
        this.addPreserveHeaders(ParamUtils.getOptionalParam(paramIncl, "transport.mail.PreserveHeaders"));
        this.addRemoveHeaders(ParamUtils.getOptionalParam(paramIncl, "transport.mail.RemoveHeaders"));
        String option = ParamUtils.getOptionalParam(paramIncl, "transport.mail.ActionAfterProcess");
        this.actionAfterProcess = "MOVE".equals(option) ? 1 : 0;
        option = ParamUtils.getOptionalParam(paramIncl, "transport.mail.ActionAfterFailure");
        this.actionAfterFailure = "MOVE".equals(option) ? 1 : 0;
        this.moveAfterProcess = ParamUtils.getOptionalParam(paramIncl, "transport.mail.MoveAfterProcess");
        this.moveAfterFailure = ParamUtils.getOptionalParam(paramIncl, "transport.mail.MoveAfterFailure");
        String processInParallel = ParamUtils.getOptionalParam(paramIncl, "transport.mail.ProcessInParallel");
        if (processInParallel != null) {
            this.processingMailInParallel = Boolean.parseBoolean(processInParallel);
            if (this.log.isDebugEnabled() && this.processingMailInParallel) {
                this.log.debug("Parallel mail processing enabled for : " + address);
            }
        }
        if ((pollInParallel = ParamUtils.getOptionalParam(paramIncl, "transport.ConcurrentPollingAllowed")) != null) {
            this.setConcurrentPollingAllowed(Boolean.parseBoolean(pollInParallel));
            if (this.log.isDebugEnabled() && this.isConcurrentPollingAllowed()) {
                this.log.debug("Concurrent mail polling enabled for : " + address);
            }
        }
        if ((strMaxRetryCount = ParamUtils.getOptionalParam(paramIncl, "transport.mail.MaxRetryCount")) != null) {
            this.maxRetryCount = Integer.parseInt(strMaxRetryCount);
        }
        if ((strReconnectTimeout = ParamUtils.getOptionalParam(paramIncl, "transport.mail.ReconnectTimeout")) != null) {
            this.reconnectTimeout = Integer.parseInt(strReconnectTimeout) * 1000;
        }
        return super.loadConfiguration(paramIncl);
    }

    public synchronized void processingUID(String uid) {
        this.uidList.add(uid);
    }

    public synchronized boolean isProcessingUID(String uid) {
        return this.uidList.contains(uid);
    }

    public synchronized void removeUID(String uid) {
        this.uidList.remove(uid);
    }
}

