/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.io.IOException;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.io.output.CountingOutputStream;

public class WSMimeMessage
extends MimeMessage {
    private long bytesSent = -1L;
    private String fromAddress;

    WSMimeMessage(Session session, String fromAddress) {
        super(session);
        this.fromAddress = fromAddress;
    }

    @Override
    protected void updateMessageID() throws MessagingException {
        if (this.getHeader("Message-ID") == null) {
            String uuid = "<" + UUIDGenerator.getUUID().replaceAll(":", ".") + this.fromAddress + ">";
            this.setHeader("Message-ID", uuid);
        }
    }

    @Override
    public void writeTo(OutputStream out, String[] ignoreHeaders) throws MessagingException, IOException {
        if (this.bytesSent == -1L) {
            CountingOutputStream countingOut = new CountingOutputStream(out);
            super.writeTo(countingOut, ignoreHeaders);
            this.bytesSent = countingOut.getByteCount();
        } else {
            super.writeTo(out, ignoreHeaders);
        }
    }

    public long getBytesSent() {
        return this.bytesSent;
    }
}

