/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.base.AbstractTransportListenerEx;
import org.apache.axis2.transport.tcp.TCPEndpoint;
import org.apache.axis2.transport.tcp.TCPServer;

public class TCPTransportListener
extends AbstractTransportListenerEx<TCPEndpoint> {
    private Map<TCPEndpoint, TCPServer> serverTable = new ConcurrentHashMap<TCPEndpoint, TCPServer>();

    @Override
    protected void doInit() throws AxisFault {
    }

    @Override
    protected TCPEndpoint createEndpoint() {
        return new TCPEndpoint();
    }

    @Override
    protected void startEndpoint(TCPEndpoint endpoint) throws AxisFault {
        try {
            TCPServer server = new TCPServer(endpoint, this.workerPool);
            server.startServer();
            this.serverTable.put(endpoint, server);
        }
        catch (IOException e) {
            this.handleException("Error while starting the TCP endpoint", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopEndpoint(TCPEndpoint endpoint) {
        try {
            TCPServer server = this.serverTable.get(endpoint);
            if (server != null) {
                server.stopServer();
            }
        }
        catch (IOException e) {
            this.log.error("Error while stopping the TCP endpoint", e);
        }
        finally {
            this.serverTable.remove(endpoint);
        }
    }
}

