/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WrappedDataHandler
extends DataHandler {
    private static final Log log = LogFactory.getLog(WrappedDataHandler.class);
    DataHandler delegate;
    String contentType;
    private static FakeDataSource FAKE_DS = new FakeDataSource();

    public WrappedDataHandler(DataHandler _delegate, String _contentType) {
        super(FAKE_DS);
        this.delegate = _delegate;
        this.contentType = _contentType;
        if (log.isDebugEnabled()) {
            log.debug("Created instance of WrappedDatahandler: " + this.toString() + ", contentType=" + this.contentType + "\nDelegate DataHandler: " + this.delegate.toString());
        }
    }

    @Override
    public CommandInfo[] getAllCommands() {
        return this.delegate.getAllCommands();
    }

    @Override
    public Object getBean(CommandInfo paramCommandInfo) {
        return this.delegate.getBean(paramCommandInfo);
    }

    @Override
    public CommandInfo getCommand(String paramString) {
        return this.delegate.getCommand(paramString);
    }

    @Override
    public Object getContent() throws IOException {
        return this.delegate.getContent();
    }

    @Override
    public String getContentType() {
        return this.contentType != null ? this.contentType : this.delegate.getContentType();
    }

    @Override
    public DataSource getDataSource() {
        return this.delegate.getDataSource();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    @Override
    public CommandInfo[] getPreferredCommands() {
        return this.delegate.getPreferredCommands();
    }

    @Override
    public Object getTransferData(DataFlavor paramDataFlavor) throws UnsupportedFlavorException, IOException {
        return this.delegate.getTransferData(paramDataFlavor);
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return this.delegate.getTransferDataFlavors();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor paramDataFlavor) {
        return this.delegate.isDataFlavorSupported(paramDataFlavor);
    }

    @Override
    public synchronized void setCommandMap(CommandMap paramCommandMap) {
        this.delegate.setCommandMap(paramCommandMap);
    }

    @Override
    public void writeTo(OutputStream paramOutputStream) throws IOException {
        this.delegate.writeTo(paramOutputStream);
    }

    private static class FakeDataSource
    implements DataSource {
        private FakeDataSource() {
        }

        @Override
        public String getContentType() {
            return "application/octet-stream";
        }

        @Override
        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return "FakeDataSource";
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

