/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli;

import java.io.File;
import org.apache.stratos.cli.StratosApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliTool {
    private static final Logger logger = LoggerFactory.getLogger(CliTool.class);

    public static void main(String[] args) {
        CliTool cliTool = new CliTool();
        cliTool.createConfigDirectory();
        cliTool.handleConsoleInputs(args);
    }

    private void handleConsoleInputs(String[] arguments) {
        if (logger.isInfoEnabled()) {
            logger.info("Stratos CLI Started...");
        }
        StratosApplication application = new StratosApplication(arguments);
        application.start(arguments);
    }

    private void createConfigDirectory() {
        File stratosFile = new File(System.getProperty("user.home"), ".stratos");
        if (stratosFile.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info("Using directory: {}", (Object)stratosFile.getPath());
            }
        } else if (stratosFile.mkdir()) {
            if (logger.isInfoEnabled()) {
                logger.info("Created directory: {}", (Object)stratosFile.getPath());
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn("Failed to created directory: {}", (Object)stratosFile.getPath());
        }
    }
}

