/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli;

import com.google.gson.Gson;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.stratos.cli.exception.CommandException;
import org.apache.stratos.cli.utils.CommandLineUtils;
import org.apache.stratos.cli.utils.RowMapper;
import org.apache.stratos.manager.dto.Cartridge;
import org.apache.stratos.manager.dto.PolicyDefinition;
import org.apache.stratos.manager.dto.SubscriptionInfo;
import org.apache.stratos.manager.stub.ApplicationManagementServiceADCExceptionException;
import org.apache.stratos.manager.stub.ApplicationManagementServiceAlreadySubscribedExceptionException;
import org.apache.stratos.manager.stub.ApplicationManagementServiceDomainMappingExistsExceptionException;
import org.apache.stratos.manager.stub.ApplicationManagementServiceDuplicateCartridgeAliasExceptionException;
import org.apache.stratos.manager.stub.ApplicationManagementServiceInvalidCartridgeAliasExceptionException;
import org.apache.stratos.manager.stub.ApplicationManagementServiceInvalidRepositoryExceptionException;
import org.apache.stratos.manager.stub.ApplicationManagementServiceNotSubscribedExceptionException;
import org.apache.stratos.manager.stub.ApplicationManagementServicePolicyExceptionException;
import org.apache.stratos.manager.stub.ApplicationManagementServiceRepositoryCredentialsRequiredExceptionException;
import org.apache.stratos.manager.stub.ApplicationManagementServiceRepositoryRequiredExceptionException;
import org.apache.stratos.manager.stub.ApplicationManagementServiceRepositoryTransportExceptionException;
import org.apache.stratos.manager.stub.ApplicationManagementServiceStub;
import org.apache.stratos.manager.stub.ApplicationManagementServiceUnregisteredCartridgeExceptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineService {
    private static final Logger logger = LoggerFactory.getLogger(CommandLineService.class);
    private ApplicationManagementServiceStub stub;

    private CommandLineService() {
    }

    public static CommandLineService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private void initializeApplicationManagementStub(String serverURL, String username, String password) throws AxisFault {
        HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
        authenticator.setUsername(username);
        authenticator.setPassword(password);
        authenticator.setPreemptiveAuthentication(true);
        ConfigurationContext configurationContext = null;
        try {
            configurationContext = ConfigurationContextFactory.createDefaultConfigurationContext();
        }
        catch (Exception e) {
            String msg = "Backend error occurred. Please contact the service admins!";
            throw new AxisFault(msg, e);
        }
        HashMap<String, TransportOutDescription> transportsOut = configurationContext.getAxisConfiguration().getTransportsOut();
        for (TransportOutDescription transportOutDescription : transportsOut.values()) {
            transportOutDescription.getSender().init(configurationContext, transportOutDescription);
        }
        ApplicationManagementServiceStub stub = new ApplicationManagementServiceStub(configurationContext, serverURL + "/services/ApplicationManagementService");
        ServiceClient client = stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", authenticator);
        option.setTimeOutInMilliSeconds(300000L);
        this.stub = stub;
    }

    public boolean login(String serverURL, String username, String password, boolean validateLogin) throws CommandException {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLContext.setDefault(sc);
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while authentication process!", e);
        }
        try {
            this.initializeApplicationManagementStub(serverURL, username, password);
        }
        catch (AxisFault e) {
            System.out.println("Error connecting to the back-end");
            throw new CommandException(e);
        }
        try {
            if (validateLogin) {
                String tenantDomain = this.stub.getTenantDomain();
                if (logger.isDebugEnabled()) {
                    logger.debug("Tenant Domain {}", (Object)tenantDomain);
                }
                return tenantDomain != null;
            }
            return true;
        }
        catch (RemoteException e) {
            System.out.println("Authentication failed!");
            throw new CommandException(e);
        }
    }

    public void listSubscribedCartridges(final boolean full) throws CommandException {
        try {
            Cartridge[] cartridges = this.stub.getSubscribedCartridges();
            if (cartridges == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No subscribed cartridges found");
                }
                System.out.println("There are no subscribed cartridges");
                return;
            }
            RowMapper<Cartridge> cartridgeMapper = new RowMapper<Cartridge>(){

                @Override
                public String[] getData(Cartridge cartridge) {
                    String[] data = full ? new String[9] : new String[7];
                    data[0] = cartridge.getCartridgeType();
                    data[1] = cartridge.getDisplayName();
                    data[2] = cartridge.getVersion();
                    data[3] = cartridge.getMultiTenant() ? "Multi-Tenant" : "Single-Tenant";
                    data[4] = cartridge.getCartridgeAlias();
                    data[5] = cartridge.getStatus();
                    String string = data[6] = cartridge.getMultiTenant() ? "N/A" : String.valueOf(cartridge.getActiveInstances());
                    if (full) {
                        data[7] = CommandLineService.this.getAccessURLs(cartridge);
                        data[8] = cartridge.getRepoURL() != null ? cartridge.getRepoURL() : "";
                    }
                    return data;
                }
            };
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("Type");
            headers.add("Name");
            headers.add("Version");
            headers.add("Tenancy Model");
            headers.add("Alias");
            headers.add("Status");
            headers.add("Running Instances");
            if (full) {
                headers.add("Access URL(s)");
                headers.add("Repo URL");
            }
            System.out.println("Subscribed Cartridges:");
            CommandLineUtils.printTable(cartridges, cartridgeMapper, headers.toArray(new String[headers.size()]));
            System.out.println();
        }
        catch (ApplicationManagementServiceADCExceptionException e) {
            this.handleException("cannot.list.subscribed.cartridges", e, new Object[0]);
        }
        catch (RemoteException e) {
            this.handleException(e);
        }
    }

    public void listAvailableCartridges() throws CommandException {
        try {
            Cartridge[] multiTenantCatridges = this.stub.getAvailableCartridges(true);
            if (multiTenantCatridges == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No multi-tenant cartridges available");
                }
                System.out.println("There are no multi-tenant cartridges available");
            }
            RowMapper<Cartridge> cartridgeMapper = new RowMapper<Cartridge>(){

                @Override
                public String[] getData(Cartridge cartridge) {
                    String[] data = new String[]{cartridge.getCartridgeType(), cartridge.getDisplayName(), cartridge.getVersion()};
                    return data;
                }
            };
            System.out.println("Available Multi-Tenant Cartridges:");
            CommandLineUtils.printTable(multiTenantCatridges, cartridgeMapper, "Type", "Name", "Version");
            System.out.println();
            Cartridge[] singleTenantCatridges = this.stub.getAvailableCartridges(false);
            if (singleTenantCatridges == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No single-tenant cartridges available");
                }
                System.out.println("There are no single-tenant cartridges available");
            }
            System.out.println("Available Single-Tenant Cartridges:");
            CommandLineUtils.printTable(singleTenantCatridges, cartridgeMapper, "Type", "Name", "Version");
            System.out.println();
        }
        catch (ApplicationManagementServiceADCExceptionException e) {
            this.handleException("cannot.list.available.cartridges", e, new Object[0]);
        }
        catch (RemoteException e) {
            this.handleException(e);
        }
    }

    public void listAvailablePolicies() throws CommandException {
        try {
            PolicyDefinition[] policies = this.stub.getPolicyDefinitions();
            if (policies == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No policies available");
                }
                System.out.println("There are no policies available");
            }
            RowMapper<PolicyDefinition> policyMapper = new RowMapper<PolicyDefinition>(){

                @Override
                public String[] getData(PolicyDefinition policyDefinition) {
                    String[] data = new String[]{policyDefinition.getName(), policyDefinition.getDescription(), policyDefinition.getDefaultPolicy() ? "Yes" : "No"};
                    return data;
                }
            };
            CommandLineUtils.printTable(policies, policyMapper, "Policy Name", "Description", "Default");
            System.out.println();
        }
        catch (RemoteException e) {
            this.handleException(e);
        }
    }

    public void info(String alias) throws CommandException {
        try {
            Cartridge cartridge = null;
            try {
                cartridge = this.stub.getCartridgeInfo(alias);
            }
            catch (ApplicationManagementServiceADCExceptionException e) {
                this.handleException(e);
                return;
            }
            catch (ApplicationManagementServiceNotSubscribedExceptionException e) {
                this.handleException("notsubscribed.error", e, alias);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Cartridge Info: {}", (Object)new Gson().toJson(cartridge));
            }
            String FORMAT = "%-20s: %s%n";
            System.out.println();
            System.out.println("Cartridge Information");
            System.out.println("---------------------");
            System.out.format("%-20s: %s%n", "Cartridge", cartridge.getCartridgeType());
            System.out.format("%-20s: %s%n", "Name", cartridge.getDisplayName());
            System.out.format("%-20s: %s%n", "Description", cartridge.getDescription());
            System.out.format("%-20s: %s%n", "Version", cartridge.getVersion());
            System.out.format("%-20s: %s%n", "Tenancy Model", cartridge.getMultiTenant() ? "Multi-Tenant" : "Single-Tenant");
            System.out.format("%-20s: %s%n", "Alias", cartridge.getCartridgeAlias());
            if (StringUtils.isNotBlank(cartridge.getPolicyDescription())) {
                System.out.format("%-20s: %s%n", "Policy", cartridge.getPolicyDescription());
            }
            System.out.format("%-20s: %s%n", "Access URL(s)", this.getAccessURLs(cartridge));
            if (StringUtils.isNotBlank(cartridge.getIp())) {
                System.out.format("%-20s: %s%n", "Host", cartridge.getIp());
            }
            if (StringUtils.isNotBlank(cartridge.getDbUserName())) {
                System.out.format("%-20s: %s%n", "Database Username", cartridge.getDbUserName());
            }
            if (StringUtils.isNotBlank(cartridge.getPassword())) {
                System.out.format("%-20s: %s%n", "Password", cartridge.getPassword());
            }
            if (StringUtils.isNotBlank(cartridge.getRepoURL())) {
                System.out.format("%-20s: %s%n", "Repository URL", cartridge.getRepoURL());
            }
            System.out.format("%-20s: %s%n", "Status", cartridge.getStatus());
            System.out.format("%-20s: %s%n", "Running Instances", cartridge.getMultiTenant() ? "N/A" : String.valueOf(cartridge.getActiveInstances()));
            System.out.println();
        }
        catch (RemoteException e) {
            this.handleException(e);
        }
    }

    public void unsubscribe(String alias) throws CommandException {
        try {
            this.stub.unsubscribe(alias);
            System.out.println("You have successfully unsubscribed " + alias);
        }
        catch (ApplicationManagementServiceADCExceptionException e) {
            this.handleException("cannot.unsubscribe", e, new Object[0]);
        }
        catch (ApplicationManagementServiceNotSubscribedExceptionException e) {
            this.handleException("notsubscribed.error", e, alias);
        }
        catch (RemoteException e) {
            this.handleException(e);
        }
    }

    public void sync(String alias) throws CommandException {
        try {
            System.out.format("Synchronizing repository for alias: %s%n", alias);
            this.stub.synchronizeRepository(alias);
        }
        catch (ApplicationManagementServiceADCExceptionException e) {
            this.handleException("cannot.syncrepo", e, new Object[0]);
        }
        catch (RemoteException e) {
            this.handleException(e);
        }
        catch (ApplicationManagementServiceNotSubscribedExceptionException e) {
            this.handleException("notsubscribed.error", e, alias);
        }
    }

    public String addDomainMapping(String domain, String alias) throws CommandException {
        try {
            return this.stub.addDomainMapping(domain, alias);
        }
        catch (ApplicationManagementServiceADCExceptionException e) {
            this.handleException("cannot.mapdomain", e, new Object[0]);
        }
        catch (RemoteException e) {
            this.handleException(e);
        }
        catch (ApplicationManagementServiceNotSubscribedExceptionException e) {
            this.handleException("notsubscribed.error", e, alias);
        }
        catch (ApplicationManagementServiceDomainMappingExistsExceptionException e) {
            this.handleException("domainmapping.exists.error", e, domain, alias);
        }
        return null;
    }

    public void removeDomainMapping(String alias) throws CommandException {
        try {
            this.stub.removeDomainMapping(alias);
            System.out.format("Domain mapping removed for alias: %s.%n", alias);
        }
        catch (ApplicationManagementServiceADCExceptionException e) {
            this.handleException("cannot.removedomain", e, new Object[0]);
        }
        catch (RemoteException e) {
            this.handleException(e);
        }
        catch (ApplicationManagementServiceNotSubscribedExceptionException e) {
            this.handleException("notsubscribed.error", e, alias);
        }
    }

    public void subscribe(String cartridgeType, String alias, String policy, String externalRepoURL, boolean privateRepo, String username, String password, String dataCartridgeType, String dataCartridgeAlias) throws CommandException {
        SubscriptionInfo subcriptionConnectInfo = null;
        if (StringUtils.isNotBlank(dataCartridgeType) && StringUtils.isNotBlank(dataCartridgeAlias)) {
            System.out.format("Subscribing to data cartridge %s with alias %s.%n", dataCartridgeType, dataCartridgeAlias);
            try {
                subcriptionConnectInfo = this.stub.subscribe(dataCartridgeType, dataCartridgeAlias, null, null, false, null, null, null, null);
                System.out.format("You have successfully subscribed to %s cartridge with alias %s.%n", dataCartridgeType, dataCartridgeAlias);
                System.out.format("%nSubscribing to %s cartridge and connecting with %s data cartridge.%n", alias, dataCartridgeAlias);
            }
            catch (RemoteException e) {
                this.handleException(e);
            }
            catch (ApplicationManagementServiceADCExceptionException e) {
                this.handleException("cannot.subscribe", e, new Object[0]);
            }
            catch (ApplicationManagementServiceRepositoryRequiredExceptionException e) {
                this.handleException("repository.required", e, new Object[0]);
            }
            catch (ApplicationManagementServiceUnregisteredCartridgeExceptionException e) {
                this.handleException("cartridge.notregistered", e, dataCartridgeType);
            }
            catch (ApplicationManagementServiceInvalidCartridgeAliasExceptionException e) {
                this.handleException("cartridge.invalid.alias", e, new Object[0]);
            }
            catch (ApplicationManagementServiceAlreadySubscribedExceptionException e) {
                this.handleException("cartridge.already.subscribed", e, e.getFaultMessage().getAlreadySubscribedException().getCartridgeType());
            }
            catch (ApplicationManagementServiceDuplicateCartridgeAliasExceptionException e) {
                this.handleException("cartridge.alias.duplicate", e, dataCartridgeAlias);
            }
            catch (ApplicationManagementServicePolicyExceptionException e) {
                this.handleException("policy.error", e, new Object[0]);
            }
            catch (ApplicationManagementServiceRepositoryTransportExceptionException e) {
                this.handleException("repository.transport.error", e, externalRepoURL);
            }
            catch (ApplicationManagementServiceRepositoryCredentialsRequiredExceptionException e) {
                this.handleException("repository.credentials.required", e, externalRepoURL);
            }
            catch (ApplicationManagementServiceInvalidRepositoryExceptionException e) {
                this.handleException("repository.invalid.error", e, externalRepoURL);
            }
        }
        try {
            Cartridge cart;
            SubscriptionInfo subcriptionInfo = this.stub.subscribe(cartridgeType, alias, policy, externalRepoURL, privateRepo, username, password, dataCartridgeType, dataCartridgeAlias);
            System.out.format("You have successfully subscribed to %s cartridge with alias %s.%n", cartridgeType, alias);
            String repoURL = null;
            String hostnames = null;
            String hostnamesLabel = null;
            if (subcriptionInfo != null) {
                repoURL = subcriptionInfo.getRepositoryURL();
                hostnames = subcriptionInfo.getHostname();
                hostnamesLabel = "host name";
                if (repoURL != null) {
                    System.out.println("GIT Repository URL: " + repoURL);
                }
                cart = this.stub.getCartridgeInfo(alias);
                System.out.format("Your application is being published here. %s%n", this.getAccessURLs(cart));
            }
            if (subcriptionConnectInfo != null) {
                hostnames = hostnames + ", " + subcriptionConnectInfo.getHostname();
                hostnamesLabel = "host names";
                cart = this.stub.getCartridgeInfo(alias);
                System.out.format("Your data application is being published here. %s%n", this.getAccessURLs(cart));
            }
            if (externalRepoURL != null) {
                String takeTimeMsg = "(this might take few minutes... depending on repo size)\n";
                System.out.println(takeTimeMsg);
            }
            System.out.format("Please map the %s \"%s\" to ELB IP%n", hostnamesLabel, hostnames);
        }
        catch (RemoteException e) {
            this.handleException(e);
        }
        catch (ApplicationManagementServiceADCExceptionException e) {
            this.handleException("cannot.subscribe", e, new Object[0]);
        }
        catch (ApplicationManagementServiceRepositoryRequiredExceptionException e) {
            this.handleException("repository.required", e, new Object[0]);
        }
        catch (ApplicationManagementServiceUnregisteredCartridgeExceptionException e) {
            this.handleException("cartridge.notregistered", e, cartridgeType);
        }
        catch (ApplicationManagementServiceInvalidCartridgeAliasExceptionException e) {
            this.handleException("cartridge.invalid.alias", e, new Object[0]);
        }
        catch (ApplicationManagementServiceAlreadySubscribedExceptionException e) {
            this.handleException("cartridge.already.subscribed", e, e.getFaultMessage().getAlreadySubscribedException().getCartridgeType());
        }
        catch (ApplicationManagementServiceDuplicateCartridgeAliasExceptionException e) {
            this.handleException("cartridge.alias.duplicate", e, alias);
        }
        catch (ApplicationManagementServicePolicyExceptionException e) {
            this.handleException("policy.error", e, new Object[0]);
        }
        catch (ApplicationManagementServiceRepositoryTransportExceptionException e) {
            this.handleException("repository.transport.error", e, externalRepoURL);
        }
        catch (ApplicationManagementServiceRepositoryCredentialsRequiredExceptionException e) {
            this.handleException("repository.credentials.required", e, externalRepoURL);
        }
        catch (ApplicationManagementServiceInvalidRepositoryExceptionException e) {
            this.handleException("repository.invalid.error", e, externalRepoURL);
        }
        catch (ApplicationManagementServiceNotSubscribedExceptionException e) {
            this.handleException("notsubscribed.error", e, alias);
        }
    }

    private String getAccessURLs(Cartridge cartridge) {
        String[] accessURLs = cartridge.getAccessURLs();
        StringBuilder urlBuilder = new StringBuilder();
        if (accessURLs != null) {
            for (int i = 0; i < accessURLs.length; ++i) {
                String url = accessURLs[i];
                if (url == null) continue;
                if (i > 0) {
                    urlBuilder.append(", ");
                }
                urlBuilder.append(url);
            }
        }
        return urlBuilder.toString();
    }

    private void handleException(Exception e) throws CommandException {
        String message;
        if (logger.isDebugEnabled()) {
            logger.debug("Displaying message from Exception {}\n{}", (Object)e.getClass(), (Object)e.getMessage());
        }
        if ((message = e.getMessage()) == null || message != null && message.contains("Exception")) {
            message = "Error executing command!";
        }
        if (logger.isErrorEnabled()) {
            logger.error(message);
        }
        System.out.println(message);
        throw new CommandException(message, e);
    }

    private void handleException(String key, Exception e, Object ... args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Displaying message for {}. Exception thrown is {}", (Object)key, (Object)e.getClass());
        }
        String message = CommandLineUtils.getMessage(key, args);
        if (logger.isErrorEnabled()) {
            logger.error(message);
        }
        System.out.println(message);
        throw new CommandException(message, e);
    }

    private static class SingletonHolder {
        private static final CommandLineService INSTANCE = new CommandLineService();

        private SingletonHolder() {
        }
    }
}

