/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli;

import java.io.IOException;
import java.net.ConnectException;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.stratos.cli.GenericRestClient;
import org.apache.stratos.cli.WebClientWrapper;

public class RestClient
implements GenericRestClient {
    private String baseURL;
    private String username;
    private String password;
    private final int TIME_OUT_PARAM = 6000000;

    public RestClient(String baseURL, String username, String password) {
        this.baseURL = baseURL;
        this.username = username;
        this.password = password;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public HttpResponse doPost(DefaultHttpClient httpClient, String resourcePath, String jsonParamString) throws Exception {
        try {
            HttpPost postRequest = new HttpPost(resourcePath);
            StringEntity input = new StringEntity(jsonParamString);
            input.setContentType("application/json");
            postRequest.setEntity(input);
            String userPass = this.username + ":" + this.password;
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userPass.getBytes("UTF-8"));
            postRequest.addHeader("Authorization", basicAuth);
            httpClient = (DefaultHttpClient)WebClientWrapper.wrapClient(httpClient);
            HttpParams params = httpClient.getParams();
            HttpConnectionParams.setConnectionTimeout(params, 6000000);
            HttpConnectionParams.setSoTimeout(params, 6000000);
            CloseableHttpResponse response = httpClient.execute(postRequest);
            return response;
        }
        catch (ClientProtocolException e) {
            throw new ClientProtocolException();
        }
        catch (ConnectException e) {
            throw new ConnectException();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public HttpResponse doGet(DefaultHttpClient httpClient, String resourcePath) throws Exception {
        try {
            HttpGet getRequest = new HttpGet(resourcePath);
            getRequest.addHeader("Content-Type", "application/json");
            String userPass = this.username + ":" + this.password;
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userPass.getBytes("UTF-8"));
            getRequest.addHeader("Authorization", basicAuth);
            httpClient = (DefaultHttpClient)WebClientWrapper.wrapClient(httpClient);
            HttpParams params = httpClient.getParams();
            HttpConnectionParams.setConnectionTimeout(params, 6000000);
            HttpConnectionParams.setSoTimeout(params, 6000000);
            CloseableHttpResponse response = httpClient.execute(getRequest);
            return response;
        }
        catch (ClientProtocolException e) {
            throw new ClientProtocolException();
        }
        catch (ConnectException e) {
            throw new ConnectException();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public HttpResponse doDelete(DefaultHttpClient httpClient, String resourcePath) {
        try {
            HttpDelete httpDelete = new HttpDelete(resourcePath);
            httpDelete.addHeader("Content-Type", "application/json");
            String userPass = this.username + ":" + this.password;
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userPass.getBytes("UTF-8"));
            httpDelete.addHeader("Authorization", basicAuth);
            httpClient = (DefaultHttpClient)WebClientWrapper.wrapClient(httpClient);
            HttpParams params = httpClient.getParams();
            HttpConnectionParams.setConnectionTimeout(params, 6000000);
            HttpConnectionParams.setSoTimeout(params, 6000000);
            CloseableHttpResponse response = httpClient.execute(httpDelete);
            return response;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void doPut() {
    }
}

