/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.net.SocketException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.stratos.cli.RestClient;
import org.apache.stratos.cli.beans.SubscriptionInfo;
import org.apache.stratos.cli.beans.TenantInfoBean;
import org.apache.stratos.cli.beans.autoscaler.partition.Partition;
import org.apache.stratos.cli.beans.autoscaler.policy.autoscale.AutoscalePolicy;
import org.apache.stratos.cli.beans.autoscaler.policy.deployment.DeploymentPolicy;
import org.apache.stratos.cli.beans.cartridge.Cartridge;
import org.apache.stratos.cli.beans.cartridge.CartridgeInfoBean;
import org.apache.stratos.cli.beans.cartridge.PortMapping;
import org.apache.stratos.cli.beans.cartridge.ServiceDefinitionBean;
import org.apache.stratos.cli.beans.topology.Cluster;
import org.apache.stratos.cli.beans.topology.Member;
import org.apache.stratos.cli.exception.CommandException;
import org.apache.stratos.cli.utils.CommandLineUtils;
import org.apache.stratos.cli.utils.RowMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestCommandLineService {
    private static final Logger logger = LoggerFactory.getLogger(RestCommandLineService.class);
    private RestClient restClient;
    private final String initializeCookieEndpoint = "/stratos/admin/cookie";
    private final String listAvailableCartridgesRestEndpoint = "/stratos/admin/cartridge/available/list";
    private final String listSubscribedCartridgesRestEndpoint = "/stratos/admin/cartridge/list/subscribed";
    private final String listSubscribedCartridgeInfoRestEndpoint = "/stratos/admin/cartridge/info/";
    private final String listClusterRestEndpoint = "/stratos/admin/cluster/";
    private final String subscribCartridgeRestEndpoint = "/stratos/admin/cartridge/subscribe";
    private final String addTenantEndPoint = "/stratos/admin/tenant";
    private final String unsubscribeTenantEndPoint = "/stratos/admin/cartridge/unsubscribe";
    private final String cartridgeDeploymentEndPoint = "/stratos/admin/cartridge/definition";
    private final String syncEndPoint = "/stratos/admin/cartridge/sync";
    private final String partitionDeploymentEndPoint = "/stratos/admin/policy/deployment/partition";
    private final String autoscalingPolicyDeploymentEndPoint = "/stratos/admin/policy/autoscale";
    private final String deploymentPolicyDeploymentEndPoint = "/stratos/admin/policy/deployment";
    private final String listParitionRestEndPoint = "/stratos/admin/partition";
    private final String listAutoscalePolicyRestEndPoint = "/stratos/admin/policy/autoscale";
    private final String listDeploymentPolicyRestEndPoint = "/stratos/admin/policy/deployment";
    private final String deployServiceEndPoint = "/stratos/admin/service/definition";
    private final String listDeployServicesRestEndPoint = "/stratos/admin/service";
    private final String deactivateTenantRestEndPoint = "/stratos/admin/tenant/deactivate";
    private final String activateTenantRestEndPoint = "/stratos/admin/tenant/activate";
    private final String listAllTenantRestEndPoint = "/stratos/admin/tenant/list";

    public static RestCommandLineService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String serverURL, String username, String password, boolean validateLogin) throws Exception {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLContext.setDefault(sc);
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while authentication process!", e);
        }
        try {
            this.initializeRestClient(serverURL, username, password);
            if (logger.isDebugEnabled()) {
                logger.debug("Initialized REST Client for user {}", (Object)username);
            }
        }
        catch (AxisFault e) {
            System.out.println("Error connecting to the back-end");
            throw new CommandException(e);
        }
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            if (validateLogin) {
                HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cookie");
                if (response != null) {
                    String responseCode = "" + response.getStatusLine().getStatusCode();
                    if (responseCode.equals("200") && response.toString().contains("WWW-Authenticate: Basic")) {
                        boolean bl = true;
                        return bl;
                    }
                    System.out.println("Invalid STRATOS_URL");
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean response = true;
            return response;
        }
        catch (ClientProtocolException e) {
            System.out.println("Authentication failed!");
            boolean bl = false;
            return bl;
        }
        catch (ConnectException e) {
            System.out.println("Could not connect to stratos manager");
            boolean bl = false;
            return bl;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private void initializeRestClient(String serverURL, String username, String password) throws AxisFault {
        RestClient restClient;
        HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
        authenticator.setUsername(username);
        authenticator.setPassword(password);
        authenticator.setPreemptiveAuthentication(true);
        ConfigurationContext configurationContext = null;
        try {
            configurationContext = ConfigurationContextFactory.createDefaultConfigurationContext();
        }
        catch (Exception e) {
            String msg = "Backend error occurred. Please contact the service admins!";
            throw new AxisFault(msg, e);
        }
        HashMap<String, TransportOutDescription> transportsOut = configurationContext.getAxisConfiguration().getTransportsOut();
        for (TransportOutDescription transportOutDescription : transportsOut.values()) {
            transportOutDescription.getSender().init(configurationContext, transportOutDescription);
        }
        this.restClient = restClient = new RestClient(serverURL, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listAvailableCartridges() throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            String message;
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cartridge/available/list");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            String resultString = this.getHttpResponseString(response);
            if (resultString == null) {
                return;
            }
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            CartridgeList cartridgeList = gson.fromJson(resultString, CartridgeList.class);
            if (cartridgeList == null) {
                System.out.println("Available cartridge list is null");
                return;
            }
            CartridgeList multiTelentCartridgeList = new CartridgeList();
            CartridgeList singleTeneCartridgetList = new CartridgeList();
            ArrayList<Cartridge> multiTenetCartridge = new ArrayList<Cartridge>();
            ArrayList<Cartridge> singleTentCartridge = new ArrayList<Cartridge>();
            for (Cartridge cartridge : cartridgeList.getCartridge()) {
                if (cartridge.isMultiTenant()) {
                    multiTenetCartridge.add(cartridge);
                    continue;
                }
                singleTentCartridge.add(cartridge);
            }
            multiTelentCartridgeList.setCartridge(multiTenetCartridge);
            singleTeneCartridgetList.setCartridge(singleTentCartridge);
            RowMapper<Cartridge> cartridgeMapper = new RowMapper<Cartridge>(){

                @Override
                public String[] getData(Cartridge cartridge) {
                    String[] data = new String[]{cartridge.getCartridgeType(), cartridge.getDisplayName(), cartridge.getDescription(), cartridge.getVersion(), String.valueOf(cartridge.isMultiTenant())};
                    return data;
                }
            };
            if (multiTenetCartridge.size() == 0) {
                message = "Cannot find any deployed multi-tenant Cartridge. Please deploy a Cartridge using [deploy-cartridge] command.";
                if (logger.isDebugEnabled()) {
                    logger.debug(message);
                }
                System.out.println(message);
            } else {
                Cartridge[] cartridges = new Cartridge[multiTelentCartridgeList.getCartridge().size()];
                cartridges = multiTelentCartridgeList.getCartridge().toArray(cartridges);
                System.out.println("Available Multi-Tenant Cartridges:");
                CommandLineUtils.printTable(cartridges, cartridgeMapper, "Type", "Name", "Description", "Version", "Multitenanted");
                System.out.println();
            }
            if (singleTentCartridge.size() == 0) {
                message = "Cannot find any deployed single-tenant Cartridge. Please deploy a Cartridge using [deploy-cartridge] command.";
                if (logger.isDebugEnabled()) {
                    logger.debug(message);
                }
                System.out.println(message);
            } else {
                Cartridge[] cartridges1 = new Cartridge[singleTeneCartridgetList.getCartridge().size()];
                cartridges1 = singleTeneCartridgetList.getCartridge().toArray(cartridges1);
                System.out.println("Available Single-Tenant Cartridges:");
                CommandLineUtils.printTable(cartridges1, cartridgeMapper, "Type", "Name", "Description", "Version", "Multitenanted");
                System.out.println();
            }
        }
        catch (Exception e) {
            this.handleException("Exception in listing available cartridges", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void describeAvailableCartridges(String type) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cartridge/available/list");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            String resultString = this.getHttpResponseString(response);
            if (resultString == null) {
                return;
            }
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            CartridgeList cartridgeList = gson.fromJson(resultString, CartridgeList.class);
            if (cartridgeList == null) {
                System.out.println("Available cartridge list is null");
                return;
            }
            for (Cartridge tmp : cartridgeList.getCartridge()) {
                if (!tmp.getCartridgeType().equalsIgnoreCase(type)) continue;
                System.out.println("The cartridge is:");
                System.out.println(gson.toJson(tmp));
                return;
            }
            System.out.println("Cannot find a matching Cartridge for [type] " + type);
        }
        catch (Exception e) {
            this.handleException("Exception in listing available cartridges", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listSubscribedCartridges(final boolean full) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cartridge/list/subscribed");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            String resultString = this.getHttpResponseString(response);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            CartridgeList cartridgeList = gson.fromJson(resultString, CartridgeList.class);
            if (cartridgeList == null) {
                System.out.println("Subscribe cartridge list is null");
                return;
            }
            CartridgeList applicationCartridgeList = new CartridgeList();
            ArrayList<Cartridge> allCartridges = cartridgeList.getCartridge();
            for (Cartridge cartridge : allCartridges) {
                if (cartridge.isLoadBalancer()) continue;
                applicationCartridgeList.getCartridge().add(cartridge);
            }
            Cartridge[] cartridges = new Cartridge[applicationCartridgeList.getCartridge().size()];
            cartridges = applicationCartridgeList.getCartridge().toArray(cartridges);
            if (cartridges.length == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No subscribed cartridges found");
                }
                System.out.println("There are no subscribed cartridges");
                return;
            }
            RowMapper<Cartridge> cartridgeMapper = new RowMapper<Cartridge>(){

                @Override
                public String[] getData(Cartridge cartridge) {
                    String[] data = full ? new String[10] : new String[8];
                    data[0] = cartridge.getCartridgeType();
                    data[1] = cartridge.getDisplayName();
                    data[2] = cartridge.getVersion();
                    data[3] = cartridge.isMultiTenant() ? "Multi-Tenant" : "Single-Tenant";
                    data[4] = cartridge.getCartridgeAlias();
                    data[5] = cartridge.getStatus();
                    data[6] = cartridge.isMultiTenant() ? "N/A" : String.valueOf(cartridge.getActiveInstances());
                    data[7] = cartridge.getHostName();
                    if (full) {
                        data[8] = RestCommandLineService.this.getAccessURLs(cartridge);
                        data[9] = cartridge.getRepoURL() != null ? cartridge.getRepoURL() : "";
                    }
                    return data;
                }
            };
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("Type");
            headers.add("Name");
            headers.add("Version");
            headers.add("Tenancy Model");
            headers.add("Alias");
            headers.add("Status");
            headers.add("Running Instances");
            headers.add("Host Name");
            if (full) {
                headers.add("Access URL(s)");
                headers.add("Repo URL");
            }
            System.out.println("Subscribed Cartridges:");
            CommandLineUtils.printTable(cartridges, cartridgeMapper, headers.toArray(new String[headers.size()]));
            System.out.println();
        }
        catch (Exception e) {
            this.handleException("Exception in listing subscribe cartridges", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listSubscribedCartridgeInfo(String alias) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cartridge/info/" + alias);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            String resultString = this.getHttpResponseString(response);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            CartridgeWrapper cartridgeWrapper = gson.fromJson(resultString, CartridgeWrapper.class);
            Cartridge cartridge = cartridgeWrapper.getCartridge();
            if (cartridge == null) {
                System.out.println("Cartridge is null");
                return;
            }
            Map<String, Set<String>> lbIpMap = this.getLbIpList(cartridge, httpClient);
            Set<String> lbPrivateIpSet = lbIpMap.get("private");
            Set<String> lbFloatingIpSet = lbIpMap.get("floating");
            Cartridge[] cartridges = new Cartridge[]{cartridge};
            System.out.println("\nSubscribed Cartridges Info\n");
            System.out.println("\tType : " + cartridge.getCartridgeType());
            System.out.println("\tName : " + cartridge.getDisplayName());
            System.out.println("\tVersion : " + cartridge.getVersion());
            String tenancy = cartridge.isMultiTenant() ? "Multi-Tenant" : "Single-Tenant";
            System.out.println("\tTenancy Model\t: " + tenancy);
            System.out.println("\tAlias : " + cartridge.getCartridgeAlias());
            System.out.println("\tStatus : " + cartridge.getStatus());
            String instanceCount = cartridge.isMultiTenant() ? "N/A" : String.valueOf(cartridge.getActiveInstances());
            System.out.println("\tRunning Instances\t: " + instanceCount);
            System.out.println("\tAccess URL(s) : " + this.getAccessURLs(cartridge));
            if (cartridge.getRepoURL() != null) {
                System.out.println("\tRepo URL : " + cartridge.getRepoURL());
            }
            System.out.println("\tLB Private IP\t: " + lbPrivateIpSet.toString());
            if (lbFloatingIpSet != null) {
                System.out.println("\tLB Floating IP : " + lbFloatingIpSet.toString());
            }
            if (cartridge.getProvider().equals("data")) {
                System.out.println("\tDB-username : " + cartridge.getDbUserName());
                System.out.println("\tDB-password : " + cartridge.getPassword());
                System.out.println("\tDB-Host IP (private)  : " + cartridge.getIp());
                if (cartridge.getPublicIp() != null) {
                    System.out.println("\tDB-Host IP (floating) : " + cartridge.getPublicIp());
                }
            }
            System.out.println();
        }
        catch (Exception e) {
            this.handleException("Exception in listing subscribe cartridges", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private Map<String, Set<String>> getLbIpList(Cartridge cartridge, DefaultHttpClient httpClient) throws Exception {
        try {
            HashMap<String, Set<String>> privateFloatingLBIPMap = new HashMap<String, Set<String>>();
            HashSet<String> lbFloatingIpSet = new HashSet<String>();
            HashSet<String> lbPrivateIpSet = new HashSet<String>();
            Member[] members = this.getMembers(cartridge.getCartridgeType(), cartridge.getCartridgeAlias(), httpClient);
            HashSet<String> lbClusterIdSet = new HashSet<String>();
            for (Member member : members) {
                lbClusterIdSet.add(member.getLbClusterId());
                cartridge.setIp(member.getMemberIp());
                cartridge.setPublicIp(member.getMemberPublicIp());
            }
            for (String clusterId : lbClusterIdSet) {
                HttpResponse responseCluster = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cluster/" + "clusterId/" + clusterId);
                String responseCode = "" + responseCluster.getStatusLine().getStatusCode();
                String resultStringCluster = this.getHttpResponseString(responseCluster);
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                if (!responseCode.equals("200")) {
                    ExceptionMapper exception = gson.fromJson(resultStringCluster, ExceptionMapper.class);
                    System.out.println(exception);
                    return null;
                }
                Cluster cluster = this.getClusterObjectFromString(resultStringCluster);
                if (cluster == null) {
                    System.out.println("Subscribe cartridge list is null");
                    return null;
                }
                Member[] lbMembers = new Member[cluster.getMember().size()];
                for (Member lbMember : lbMembers = cluster.getMember().toArray(lbMembers)) {
                    lbPrivateIpSet.add(lbMember.getMemberIp());
                    lbFloatingIpSet.add(lbMember.getMemberPublicIp());
                }
            }
            privateFloatingLBIPMap.put("private", lbPrivateIpSet);
            privateFloatingLBIPMap.put("floating", lbFloatingIpSet);
            return privateFloatingLBIPMap;
        }
        catch (Exception e) {
            this.handleException("Exception in get LB ip list", e, new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listMembersOfCluster(String cartridgeType, String alias) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            Member[] members = this.getMembers(cartridgeType, alias, httpClient);
            if (members == null) {
                return;
            }
            if (members.length == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No Members found");
                }
                System.out.println("No members found for the corresponding cluster for type " + cartridgeType + ", alias " + alias);
                return;
            }
            System.out.println("\nList of members in the [cluster]: " + alias);
            for (Member member : members) {
                System.out.println("\n\tServiceName : " + member.getServiceName());
                System.out.println("\tClusterId : " + member.getClusterId());
                System.out.println("\tNewtworkPartitionId : " + member.getNetworkPartitionId());
                System.out.println("\tPartitionId : " + member.getPartitionId());
                System.out.println("\tStatus : " + member.getStatus());
                if (member.getLbClusterId() != null) {
                    System.out.println("\tLBCluster : " + member.getLbClusterId());
                }
                System.out.println("\tMemberPrivateIp : " + member.getMemberIp());
                System.out.println("\tMemberFloatingIp : " + member.getMemberPublicIp());
                System.out.println("\t-----------------------");
            }
            System.out.println("==================================================");
            System.out.println("List of LB members for the [cluster]: " + alias);
            for (Member m : members) {
                HttpResponse responseCluster = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cluster/" + "clusterId/" + m.getLbClusterId());
                String responseCode = "" + responseCluster.getStatusLine().getStatusCode();
                String resultStringCluster = this.getHttpResponseString(responseCluster);
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                if (!responseCode.equals("200")) {
                    ExceptionMapper exception = gson.fromJson(resultStringCluster, ExceptionMapper.class);
                    System.out.println(exception);
                    break;
                }
                this.printLBs(resultStringCluster);
            }
        }
        catch (Exception e) {
            this.handleException("Exception in listing subscribe cartridges", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private Member[] getMembers(String cartridgeType, String alias, DefaultHttpClient httpClient) throws Exception {
        try {
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cluster/" + cartridgeType + "/" + alias);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            Gson gson = new Gson();
            if (!responseCode.equals("200")) {
                String resultString = this.getHttpResponseString(response);
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return null;
            }
            Cluster cluster = this.getClusterObjectFromString(this.getHttpResponseString(response));
            if (cluster == null) {
                System.out.println("No existing subscriptions found for alias " + alias);
                return null;
            }
            Member[] members = new Member[cluster.getMember().size()];
            members = cluster.getMember().toArray(members);
            return members;
        }
        catch (Exception e) {
            this.handleException("Exception in get member", e, new Object[0]);
            return null;
        }
    }

    private Cluster getClusterObjectFromString(String resultString) {
        if (resultString.startsWith("{\"cluster\"")) {
            String tmp;
            resultString = tmp = resultString.substring("{\"cluster\"".length() + 1, resultString.length() - 1);
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        Cluster cluster = gson.fromJson(resultString, Cluster.class);
        return cluster;
    }

    private void printLBs(String resultString) {
        Cluster cluster = this.getClusterObjectFromString(resultString);
        if (cluster == null) {
            System.out.println("Subscribe cartridge list is null");
            return;
        }
        Member[] members = new Member[cluster.getMember().size()];
        members = cluster.getMember().toArray(members);
        if (members.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("No subscribed cartridges found");
            }
            System.out.println("There are no subscribed cartridges");
            return;
        }
        for (Member member : members) {
            System.out.println("\n\tServiceName : " + member.getServiceName());
            System.out.println("\tClusterId : " + member.getClusterId());
            System.out.println("\tNewtworkPartitionId : " + member.getNetworkPartitionId());
            System.out.println("\tPartitionId : " + member.getPartitionId());
            System.out.println("\tStatus : " + member.getStatus());
            if (member.getLbClusterId() != null) {
                System.out.println("\tLBCluster : " + member.getLbClusterId());
            }
            System.out.println("\tMemberPrivateIp : " + member.getMemberIp());
            System.out.println("\tMemberFloatingIp : " + member.getMemberPublicIp());
            System.out.println("\t-----------------------");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String cartridgeType, String alias, String externalRepoURL, boolean privateRepo, String username, String password, String asPolicy, String depPolicy, String size, boolean remoOnTermination, boolean persistanceMapping, boolean enableCommits) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        CartridgeInfoBean cartridgeInfoBean = new CartridgeInfoBean();
        cartridgeInfoBean.setCartridgeType(null);
        cartridgeInfoBean.setAlias(null);
        cartridgeInfoBean.setRepoURL(null);
        cartridgeInfoBean.setPrivateRepo(false);
        cartridgeInfoBean.setRepoUsername(null);
        cartridgeInfoBean.setRepoPassword(null);
        cartridgeInfoBean.setAutoscalePolicy(null);
        cartridgeInfoBean.setDeploymentPolicy(null);
        cartridgeInfoBean.setSize(size);
        cartridgeInfoBean.setRemoveOnTermination(remoOnTermination);
        cartridgeInfoBean.setPersistanceRequired(persistanceMapping);
        cartridgeInfoBean.setCommitsEnabled(enableCommits);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        String jsonSubscribeString = gson.toJson((Object)cartridgeInfoBean, (Type)((Object)CartridgeInfoBean.class));
        try {
            cartridgeInfoBean.setCartridgeType(cartridgeType);
            cartridgeInfoBean.setAlias(alias);
            cartridgeInfoBean.setRepoURL(externalRepoURL);
            cartridgeInfoBean.setPrivateRepo(privateRepo);
            cartridgeInfoBean.setRepoUsername(username);
            cartridgeInfoBean.setRepoPassword(password);
            cartridgeInfoBean.setAutoscalePolicy(asPolicy);
            cartridgeInfoBean.setDeploymentPolicy(depPolicy);
            cartridgeInfoBean.setSize(size);
            cartridgeInfoBean.setRemoveOnTermination(remoOnTermination);
            cartridgeInfoBean.setPersistanceRequired(persistanceMapping);
            cartridgeInfoBean.setCommitsEnabled(enableCommits);
            jsonSubscribeString = gson.toJson((Object)cartridgeInfoBean, (Type)((Object)CartridgeInfoBean.class));
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cartridge/subscribe", jsonSubscribeString);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            if (!responseCode.equals("200")) {
                String resultString = this.getHttpResponseString(response);
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            String subscriptionOutput = this.getHttpResponseString(response);
            if (subscriptionOutput == null) {
                System.out.println("Error in response");
                return;
            }
            String subscriptionOutputJSON = subscriptionOutput.substring(20, subscriptionOutput.length() - 1);
            SubscriptionInfo subcriptionInfo = gson.fromJson(subscriptionOutputJSON, SubscriptionInfo.class);
            System.out.format("You have successfully subscribed to %s cartridge with alias %s.%n", cartridgeType, alias);
            String repoURL = null;
            String hostnames = null;
            String hostnamesLabel = null;
            if (subcriptionInfo != null) {
                repoURL = subcriptionInfo.getRepositoryURL();
                hostnames = subcriptionInfo.getHostname();
                hostnamesLabel = "host name";
                if (repoURL != null) {
                    System.out.println("GIT Repository URL: " + repoURL);
                }
            }
            if (externalRepoURL != null) {
                String takeTimeMsg = "(this might take few minutes... depending on repo size)\n";
                System.out.println(takeTimeMsg);
            }
            System.out.format("Please map the %s \"%s\" to LB IP%n", hostnamesLabel, hostnames);
        }
        catch (Exception e) {
            this.handleException("Exception in subscribing to cartridge", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTenant(String admin, String firstName, String lastaName, String password, String domain, String email) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            TenantInfoBean tenantInfo = new TenantInfoBean();
            tenantInfo.setAdmin(admin);
            tenantInfo.setFirstname(firstName);
            tenantInfo.setLastname(lastaName);
            tenantInfo.setAdminPassword(password);
            tenantInfo.setTenantDomain(domain);
            tenantInfo.setEmail(email);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            String jsonString = gson.toJson((Object)tenantInfo, (Type)((Object)TenantInfoBean.class));
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/stratos/admin/tenant", jsonString);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            if (responseCode.equals("200")) {
                System.out.println("Tenant added successfully");
                return;
            }
            String resultString = this.getHttpResponseString(response);
            ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
            System.out.println(exception);
            return;
        }
        catch (Exception e) {
            this.handleException("Exception in creating tenant", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTenant(String tenantDomain) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doDelete(httpClient, this.restClient.getBaseURL() + "/stratos/admin/tenant" + "/" + tenantDomain);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have succesfully delete " + tenantDomain + " tenant");
                return;
            }
            String resultString = this.getHttpResponseString(response);
            ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
            System.out.println(exception);
            return;
        }
        catch (Exception e) {
            this.handleException("Exception in deleting " + tenantDomain + " tenant", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateTenant(String tenantDomain) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/stratos/admin/tenant/deactivate" + "/" + tenantDomain, "");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have succesfully deactivate " + tenantDomain + " tenant");
                return;
            }
            String resultString = this.getHttpResponseString(response);
            ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
            System.out.println(exception);
            return;
        }
        catch (Exception e) {
            this.handleException("Exception in deactivating " + tenantDomain + " tenant", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateTenant(String tenantDomain) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/stratos/admin/tenant/activate" + "/" + tenantDomain, "");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have succesfully activate " + tenantDomain + " tenant");
                return;
            }
            String resultString = this.getHttpResponseString(response);
            ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
            System.out.println(exception);
            return;
        }
        catch (Exception e) {
            this.handleException("Exception in activating " + tenantDomain + " tenant", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listAllTenants() throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/tenant/list");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            String resultString = this.getHttpResponseString(response);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            if (resultString == null) {
                System.out.println("Response content is empty");
                return;
            }
            TenantInfoList tenantInfoList = gson.fromJson(resultString, TenantInfoList.class);
            if (tenantInfoList == null) {
                System.out.println("Tenant information list is empty");
                return;
            }
            RowMapper<TenantInfoBean> tenantInfoMapper = new RowMapper<TenantInfoBean>(){

                @Override
                public String[] getData(TenantInfoBean tenantInfo) {
                    String[] data = new String[]{tenantInfo.getTenantDomain(), "" + tenantInfo.getTenantId(), tenantInfo.getEmail(), tenantInfo.isActive() ? "Active" : "De-active", tenantInfo.getCreatedDate()};
                    return data;
                }
            };
            TenantInfoBean[] tenants = new TenantInfoBean[tenantInfoList.getTenantInfoBean().size()];
            tenants = tenantInfoList.getTenantInfoBean().toArray(tenants);
            if (tenants.length == 0) {
                String message = "Cannot find any Tenant. Please create a new tenant using [create-tenant] command.";
                if (logger.isDebugEnabled()) {
                    logger.debug(message);
                }
                System.out.println(message);
                return;
            }
            System.out.println("Available Tenants:");
            CommandLineUtils.printTable(tenants, tenantInfoMapper, "Domain", "Tenant ID", "Email", "State", "Created Date");
            System.out.println();
        }
        catch (Exception e) {
            this.handleException("Exception in listing partitions", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String alias) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cartridge/unsubscribe", alias);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have successfully unsubscribed " + alias + " cartridge");
                return;
            }
            String resultString = this.getHttpResponseString(response);
            ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
            System.out.println(exception);
            return;
        }
        catch (Exception e) {
            this.handleException("Exception in un-subscribing cartridge", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployCartridgeDefinition(String cartridgeDefinition) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cartridge/definition", cartridgeDefinition);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have successfully deployed the cartridge");
                return;
            }
            String resultString = this.getHttpResponseString(response);
            ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
            System.out.println(exception);
            return;
        }
        catch (Exception e) {
            this.handleException("Exception in deploy cartridge definition", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployCartrigdeDefinition(String id) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doDelete(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cartridge/definition" + "/" + id);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have succesfully undeploy " + id + " cartridge");
                return;
            }
            String resultString = this.getHttpResponseString(response);
            ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
            System.out.println(exception);
            return;
        }
        catch (Exception e) {
            this.handleException("Exception in undeploying " + id + " cartridge", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployPartition(String partitionDefinition) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/stratos/admin/policy/deployment/partition", partitionDefinition);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            String resultString = this.getHttpResponseString(response);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            System.out.println("You have successfully deployed the partition");
            return;
        }
        catch (Exception e) {
            this.handleException("Exception in deploying partitions", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployAutoscalingPolicy(String autoScalingPolicy) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/stratos/admin/policy/autoscale", autoScalingPolicy);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have successfully deployed the autoscaling policy");
                return;
            }
            String resultString = this.getHttpResponseString(response);
            ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
            System.out.println(exception);
            return;
        }
        catch (Exception e) {
            this.handleException("Exception in deploying autoscale police", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployService(String deployService) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/stratos/admin/service/definition", deployService);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have succesfully deploy the multi-tenant service cluster");
                return;
            }
            String resultString = this.getHttpResponseString(response);
            ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
            System.out.println(exception);
            return;
        }
        catch (Exception e) {
            this.handleException("Exception in deploying multi-tenant service cluster", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployService(String id) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doDelete(httpClient, this.restClient.getBaseURL() + "/stratos/admin/service/definition" + "/" + id);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have succesfully undeploy multi-tenant service cluster");
                return;
            }
            String resultString = this.getHttpResponseString(response);
            ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
            System.out.println(exception);
            return;
        }
        catch (Exception e) {
            this.handleException("Exception in undeploying multi-tenant service cluster", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listDeployServices() throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/service");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                String resultString = this.getHttpResponseString(response);
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            String resultString = this.getHttpResponseString(response);
            if (resultString == null) {
                System.out.println("Response content is empty");
                return;
            }
            ServiceDefinitionList definitionList = gson.fromJson(resultString, ServiceDefinitionList.class);
            if (definitionList == null) {
                System.out.println("Deploy service list is empty");
                return;
            }
            RowMapper<ServiceDefinitionBean> deployServiceMapper = new RowMapper<ServiceDefinitionBean>(){

                @Override
                public String[] getData(ServiceDefinitionBean definition) {
                    String[] data = new String[]{definition.getServiceName(), definition.getCartridgeType(), definition.getDeploymentPolicyName(), definition.getAutoscalingPolicyName(), definition.getClusterDomain(), definition.getClusterSubDomain(), definition.getTenantRange()};
                    return data;
                }
            };
            ServiceDefinitionBean[] definitionArry = new ServiceDefinitionBean[definitionList.getServiceDefinition().size()];
            definitionArry = definitionList.getServiceDefinition().toArray(definitionArry);
            if (definitionArry.length == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No deploy services are found");
                }
                System.out.println("There are no deploy services available");
                return;
            }
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("Service Name");
            headers.add("Cartridge Type");
            headers.add("Deployment Policy Name");
            headers.add("Autoscaling Policy Name");
            headers.add("Cluster Domain");
            headers.add("Cluster Sub Domain");
            headers.add("Tenant Range");
            System.out.println("Available Deploy Services :");
            CommandLineUtils.printTable(definitionArry, deployServiceMapper, headers.toArray(new String[headers.size()]));
        }
        catch (Exception e) {
            this.handleException("Exception in listing deploy services", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployDeploymentPolicy(String deploymentPolicy) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/stratos/admin/policy/deployment", deploymentPolicy);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (responseCode.equals("200")) {
                System.out.println("You have successfully deployed the deployment policy");
                return;
            }
            String resultString = this.getHttpResponseString(response);
            ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
            System.out.println(exception);
            return;
        }
        catch (Exception e) {
            this.handleException("Exception in deploying deployment policy", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listPartitions() throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/partition");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            String resultString = this.getHttpResponseString(response);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            if (resultString == null) {
                System.out.println("Response content is empty");
                return;
            }
            PartitionList partitionList = gson.fromJson(resultString, PartitionList.class);
            if (partitionList == null) {
                System.out.println("Partition list is empty");
                return;
            }
            RowMapper<Partition> partitionMapper = new RowMapper<Partition>(){

                @Override
                public String[] getData(Partition partition) {
                    String[] data = new String[]{partition.getId(), partition.getProvider()};
                    return data;
                }
            };
            Partition[] partitions = new Partition[partitionList.getPartition().size()];
            partitions = partitionList.getPartition().toArray(partitions);
            if (partitions.length == 0) {
                String message = "Cannot find any deployed Partition. Please deploy a Partition using [deploy-partition] command.";
                if (logger.isDebugEnabled()) {
                    logger.debug(message);
                }
                System.out.println(message);
                return;
            }
            System.out.println("Available Partitions:");
            CommandLineUtils.printTable(partitions, partitionMapper, "ID", "Provider");
            System.out.println();
        }
        catch (Exception e) {
            this.handleException("Exception in listing partitions", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listAutoscalePolicies() throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/policy/autoscale");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                String resultString = this.getHttpResponseString(response);
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            String resultString = this.getHttpResponseString(response);
            if (resultString == null) {
                System.out.println("Response content is empty");
                return;
            }
            AutoscalePolicyList policyList = gson.fromJson(resultString, AutoscalePolicyList.class);
            if (policyList == null) {
                System.out.println("Autoscale policy list is empty");
                return;
            }
            RowMapper<AutoscalePolicy> partitionMapper = new RowMapper<AutoscalePolicy>(){

                @Override
                public String[] getData(AutoscalePolicy policy) {
                    String[] data = new String[]{policy.getId()};
                    return data;
                }
            };
            AutoscalePolicy[] policyArry = new AutoscalePolicy[policyList.getAutoscalePolicy().size()];
            policyArry = policyList.getAutoscalePolicy().toArray(policyArry);
            if (policyArry.length == 0) {
                String message = "Cannot find any deployed auto-scaling policy. Please deploy a policy using [deploy-autoscaling-policy] command.";
                if (logger.isDebugEnabled()) {
                    logger.debug(message);
                }
                System.out.println(message);
                return;
            }
            System.out.println("Available Auto-scaling Policies:");
            CommandLineUtils.printTable(policyArry, partitionMapper, "ID");
        }
        catch (Exception e) {
            this.handleException("Exception in listing autoscale policies", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listDeploymentPolicies() throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/policy/deployment");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                String resultString = this.getHttpResponseString(response);
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            String resultString = this.getHttpResponseString(response);
            if (resultString == null) {
                System.out.println("Response content is empty");
                return;
            }
            DeploymentPolicyList policyList = gson.fromJson(resultString, DeploymentPolicyList.class);
            if (policyList == null) {
                System.out.println("Deployment policy list is empty");
                return;
            }
            RowMapper<DeploymentPolicy> partitionMapper = new RowMapper<DeploymentPolicy>(){

                @Override
                public String[] getData(DeploymentPolicy policy) {
                    String[] data = new String[]{policy.getId()};
                    return data;
                }
            };
            DeploymentPolicy[] policyArry = new DeploymentPolicy[policyList.getDeploymentPolicy().size()];
            policyArry = policyList.getDeploymentPolicy().toArray(policyArry);
            if (policyArry.length == 0) {
                String message = "Cannot find any deployed deployment policy. Please deploy a policy using [deploy-deployment-policy] command.";
                if (logger.isDebugEnabled()) {
                    logger.debug(message);
                }
                System.out.println(message);
                return;
            }
            System.out.println("Available Deployment Policies:");
            CommandLineUtils.printTable(policyArry, partitionMapper, "ID");
            System.out.println();
        }
        catch (Exception e) {
            this.handleException("Exception in listing deployment polices", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void describeDeploymentPolicies(String id) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/policy/deployment");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                String resultString = this.getHttpResponseString(response);
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            String resultString = this.getHttpResponseString(response);
            if (resultString == null) {
                System.out.println("Response content is empty");
                return;
            }
            DeploymentPolicyList deploymentPolicyList = gson.fromJson(resultString, DeploymentPolicyList.class);
            if (deploymentPolicyList == null) {
                System.out.println("Deployment policy list is empty");
                return;
            }
            for (DeploymentPolicy policy : deploymentPolicyList.getDeploymentPolicy()) {
                if (!policy.getId().equals(id)) continue;
                System.out.println("The Deployment policy is: \n");
                System.out.println(gson.toJson(policy));
                return;
            }
            System.out.println("No matching Deployment policy found");
        }
        catch (Exception e) {
            this.handleException("Exception in listing deployment polices", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void describePartition(String id) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/partition");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                String resultString = this.getHttpResponseString(response);
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            String resultString = this.getHttpResponseString(response);
            if (resultString == null) {
                System.out.println("Response content is empty");
                return;
            }
            PartitionList partitionList = gson.fromJson(resultString, PartitionList.class);
            for (Partition partition : partitionList.getPartition()) {
                if (!partition.getId().equals(id)) continue;
                System.out.println("The Partition is:");
                System.out.println(gson.toJson(partition));
                return;
            }
            System.out.println("Cannot find a matching Partition for [id] " + id);
        }
        catch (Exception e) {
            this.handleException("Exception in listing deployment polices", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void describeAutoScalingPolicy(String id) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doGet(httpClient, this.restClient.getBaseURL() + "/stratos/admin/policy/autoscale");
            String responseCode = "" + response.getStatusLine().getStatusCode();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            if (!responseCode.equals("200")) {
                String resultString = this.getHttpResponseString(response);
                ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
                System.out.println(exception);
                return;
            }
            String resultString = this.getHttpResponseString(response);
            if (resultString == null) {
                System.out.println("Response content is empty");
                return;
            }
            AutoscalePolicyList policyList = gson.fromJson(resultString, AutoscalePolicyList.class);
            if (policyList == null) {
                System.out.println("Autoscale policy list is empty");
                return;
            }
            for (AutoscalePolicy policy : policyList.getAutoscalePolicy()) {
                if (!policy.getId().equalsIgnoreCase(id)) continue;
                System.out.println("Autoscale policy is:");
                System.out.println(gson.toJson(policy));
                return;
            }
            System.out.println("No matching Autoscale Policy found...");
        }
        catch (Exception e) {
            this.handleException("Exception in listing deployment polices", e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(String alias) throws CommandException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpResponse response = this.restClient.doPost(httpClient, this.restClient.getBaseURL() + "/stratos/admin/cartridge/sync", alias);
            String responseCode = "" + response.getStatusLine().getStatusCode();
            if (responseCode.equals("200")) {
                System.out.format("Synchronizing repository for alias: %s%n", alias);
                return;
            }
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            String resultString = this.getHttpResponseString(response);
            ExceptionMapper exception = gson.fromJson(resultString, ExceptionMapper.class);
            System.out.println(exception);
            return;
        }
        catch (Exception e) {
            this.handleException("Exception when synchronizing repository for alias: " + alias, e, new Object[0]);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    private String getAccessURLs(Cartridge cartridge) {
        PortMapping[] portMappings = cartridge.getPortMappings();
        StringBuilder urlBuilder = new StringBuilder();
        for (PortMapping portMapping : portMappings) {
            String url = portMapping.getProtocol() + "://" + cartridge.getHostName() + ":" + portMapping.getProxyPort() + "/";
            urlBuilder.append(url).append(", ");
        }
        return urlBuilder.toString();
    }

    private String getHttpResponseString(HttpResponse response) {
        try {
            String output;
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String result = "";
            while ((output = reader.readLine()) != null) {
                result = result + output;
            }
            return result;
        }
        catch (SocketException e) {
            System.out.println("Connection problem");
            return null;
        }
        catch (NullPointerException e) {
            System.out.println("Null value return from server");
            return null;
        }
        catch (IOException e) {
            System.out.println("IO error");
            return null;
        }
    }

    private void handleException(String key, Exception e, Object ... args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Displaying message for {}. Exception thrown is {}", (Object)key, (Object)e.getClass());
        }
        String message = CommandLineUtils.getMessage(key, args);
        if (logger.isErrorEnabled()) {
            logger.error(message);
        }
        System.out.println(message);
        throw new CommandException(message, e);
    }

    public class CartridgeWrapper {
        private Cartridge cartridge;

        public Cartridge getCartridge() {
            return this.cartridge;
        }

        public void setCartridge(Cartridge cartridge) {
            this.cartridge = cartridge;
        }
    }

    public class ErrorWrapper {
        private String errorCode;
        private String errorMessage;

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String toString() {
            return "Exception [errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + "]";
        }
    }

    public class ExceptionMapper {
        private ErrorWrapper Error;

        public String toString() {
            return this.Error.toString();
        }

        public ErrorWrapper getError() {
            return this.Error;
        }

        public void setError(ErrorWrapper error) {
            this.Error = error;
        }
    }

    private class CartridgeList {
        private ArrayList<Cartridge> cartridge = new ArrayList();

        public ArrayList<Cartridge> getCartridge() {
            return this.cartridge;
        }

        public void setCartridge(ArrayList<Cartridge> cartridge) {
            this.cartridge = cartridge;
        }

        CartridgeList() {
        }
    }

    private class TenantInfoList {
        private ArrayList<TenantInfoBean> tenantInfoBean = new ArrayList();

        public ArrayList<TenantInfoBean> getTenantInfoBean() {
            return this.tenantInfoBean;
        }

        public void setTenantInfoBean(ArrayList<TenantInfoBean> tenantInfoBean) {
            this.tenantInfoBean = tenantInfoBean;
        }

        TenantInfoList() {
        }
    }

    private class PartitionList {
        private ArrayList<Partition> partition = new ArrayList();

        public ArrayList<Partition> getPartition() {
            return this.partition;
        }

        public void setPartition(ArrayList<Partition> partition) {
            this.partition = partition;
        }

        PartitionList() {
        }
    }

    private class ServiceDefinitionList {
        private ArrayList<ServiceDefinitionBean> serviceDefinition = new ArrayList();

        public ArrayList<ServiceDefinitionBean> getServiceDefinition() {
            return this.serviceDefinition;
        }

        public void setServiceDefinition(ArrayList<ServiceDefinitionBean> serviceDefinition) {
            this.serviceDefinition = serviceDefinition;
        }

        ServiceDefinitionList() {
        }
    }

    private class AutoscalePolicyList {
        private ArrayList<AutoscalePolicy> autoscalePolicy = new ArrayList();

        public ArrayList<AutoscalePolicy> getAutoscalePolicy() {
            return this.autoscalePolicy;
        }

        public void setAutoscalePolicy(ArrayList<AutoscalePolicy> autoscalePolicy) {
            this.autoscalePolicy = autoscalePolicy;
        }

        AutoscalePolicyList() {
        }
    }

    private class DeploymentPolicyList {
        private ArrayList<DeploymentPolicy> deploymentPolicy = new ArrayList();

        public ArrayList<DeploymentPolicy> getDeploymentPolicy() {
            return this.deploymentPolicy;
        }

        public void setDeploymentPolicy(ArrayList<DeploymentPolicy> deploymentPolicy) {
            this.deploymentPolicy = deploymentPolicy;
        }

        DeploymentPolicyList() {
        }
    }

    private static class SingletonHolder {
        private static final RestCommandLineService INSTANCE = new RestCommandLineService();

        private SingletonHolder() {
        }
    }
}

