/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrTokenizer;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.CommandLineApplication;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.commands.ActivateTenantCommand;
import org.apache.stratos.cli.commands.AddTenantCommand;
import org.apache.stratos.cli.commands.AutoscalePolicyCommand;
import org.apache.stratos.cli.commands.AutoscalingPolicyDeploymentCommand;
import org.apache.stratos.cli.commands.CartridgeDeploymentCommand;
import org.apache.stratos.cli.commands.DeactivateTenantCommand;
import org.apache.stratos.cli.commands.DeployServiceDeploymentCommand;
import org.apache.stratos.cli.commands.DeploymentPolicyCommand;
import org.apache.stratos.cli.commands.DeploymentPolicyDeploymentCommand;
import org.apache.stratos.cli.commands.DescribeAutoScalingPolicyCommand;
import org.apache.stratos.cli.commands.DescribeCartridgeCommand;
import org.apache.stratos.cli.commands.DescribeDeploymentPolicyCommand;
import org.apache.stratos.cli.commands.DescribePartitionCommand;
import org.apache.stratos.cli.commands.ExitCommand;
import org.apache.stratos.cli.commands.HelpCommand;
import org.apache.stratos.cli.commands.ListAllTenants;
import org.apache.stratos.cli.commands.ListCartridgesCommand;
import org.apache.stratos.cli.commands.ListDeployServiceCommand;
import org.apache.stratos.cli.commands.ListMemberCommand;
import org.apache.stratos.cli.commands.ListSubscribedCartridgesCommand;
import org.apache.stratos.cli.commands.PartitionCommand;
import org.apache.stratos.cli.commands.PartitionDeploymentCommand;
import org.apache.stratos.cli.commands.SubscribeCommand;
import org.apache.stratos.cli.commands.SubscribedCartridgeInfoCommand;
import org.apache.stratos.cli.commands.SyncCommand;
import org.apache.stratos.cli.commands.UndeployCartridgeDefinitionCommand;
import org.apache.stratos.cli.commands.UndeployServiceDefinitionCommand;
import org.apache.stratos.cli.commands.UnsubscribeCommand;
import org.apache.stratos.cli.completer.CommandCompleter;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StratosApplication
extends CommandLineApplication<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(StratosApplication.class);
    private final Map<String, Command<StratosCommandContext>> commands = new TreeMap<String, Command<StratosCommandContext>>();
    private final StratosCommandContext context = new StratosCommandContext(this);
    private final Options options = this.constructOptions();

    public StratosApplication(String[] args) {
        super(args);
        this.createCommands();
    }

    private Options constructOptions() {
        Options options = new Options();
        Option usernameOption = new Option("u", "username", true, "Username");
        usernameOption.setArgName("username");
        options.addOption(usernameOption);
        Option passwordOption = new Option("p", "password", true, "Password");
        passwordOption.setArgName("password");
        passwordOption.setOptionalArg(true);
        options.addOption(passwordOption);
        options.addOption("h", "help", false, "Display this help");
        options.addOption("trace", false, "Enable trace logging");
        options.addOption("debug", false, "Enable debug logging");
        return options;
    }

    private void createCommands() {
        Command<StratosCommandContext> command = new HelpCommand();
        this.commands.put(command.getName(), command);
        command = new ExitCommand();
        this.commands.put(command.getName(), command);
        command = new SubscribeCommand();
        this.commands.put(command.getName(), command);
        command = new UnsubscribeCommand();
        this.commands.put(command.getName(), command);
        command = new ListCartridgesCommand();
        this.commands.put(command.getName(), command);
        command = new AddTenantCommand();
        this.commands.put(command.getName(), command);
        command = new ListAllTenants();
        this.commands.put(command.getName(), command);
        command = new DeactivateTenantCommand();
        this.commands.put(command.getName(), command);
        command = new ActivateTenantCommand();
        this.commands.put(command.getName(), command);
        command = new CartridgeDeploymentCommand();
        this.commands.put(command.getName(), command);
        command = new PartitionDeploymentCommand();
        this.commands.put(command.getName(), command);
        command = new AutoscalingPolicyDeploymentCommand();
        this.commands.put(command.getName(), command);
        command = new DeployServiceDeploymentCommand();
        this.commands.put(command.getName(), command);
        command = new UndeployServiceDefinitionCommand();
        this.commands.put(command.getName(), command);
        command = new ListDeployServiceCommand();
        this.commands.put(command.getName(), command);
        command = new UndeployCartridgeDefinitionCommand();
        this.commands.put(command.getName(), command);
        command = new DeploymentPolicyDeploymentCommand();
        this.commands.put(command.getName(), command);
        command = new ListSubscribedCartridgesCommand();
        this.commands.put(command.getName(), command);
        command = new PartitionCommand();
        this.commands.put(command.getName(), command);
        command = new AutoscalePolicyCommand();
        this.commands.put(command.getName(), command);
        command = new DeploymentPolicyCommand();
        this.commands.put(command.getName(), command);
        command = new ListMemberCommand();
        this.commands.put(command.getName(), command);
        command = new DescribeCartridgeCommand();
        this.commands.put(command.getName(), command);
        command = new DescribePartitionCommand();
        this.commands.put(command.getName(), command);
        command = new DescribeDeploymentPolicyCommand();
        this.commands.put(command.getName(), command);
        command = new DescribeAutoScalingPolicyCommand();
        this.commands.put(command.getName(), command);
        command = new SubscribedCartridgeInfoCommand();
        this.commands.put(command.getName(), command);
        command = new SyncCommand();
        this.commands.put(command.getName(), command);
        if (logger.isDebugEnabled()) {
            logger.debug("Created {} commands for the application. {}", (Object)this.commands.size(), (Object)this.commands.keySet());
        }
    }

    private void createAutocomplete() {
        this.reader.addCompleter(new CommandCompleter(this.commands));
    }

    @Override
    protected String getPrompt() {
        return "stratos> ";
    }

    @Override
    protected File getHistoryFile(String username) {
        File stratosFile = new File(System.getProperty("user.home"), ".stratos");
        File historyFile = new File(stratosFile, ".history_" + username);
        return historyFile;
    }

    @Override
    public int run(String[] args) {
        boolean loaded = this.loadRequiredProperties();
        if (!loaded) {
            return 2;
        }
        String[] remainingArgs = null;
        String action = null;
        String usernameInput = null;
        String passwordInput = null;
        if (args != null && args.length > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Arguments:");
                for (String arg : args) {
                    logger.debug(arg);
                }
            }
            GnuParser parser = new GnuParser();
            try {
                Options allCommandOptions = new Options();
                for (Command<StratosCommandContext> command : this.commands.values()) {
                    Options commandOptions = command.getOptions();
                    if (commandOptions == null) continue;
                    Collection allOptions = commandOptions.getOptions();
                    for (Object o : allOptions) {
                        allCommandOptions.addOption((Option)o);
                    }
                }
                Collection allOptions = this.options.getOptions();
                for (Object o : allOptions) {
                    allCommandOptions.addOption((Option)o);
                }
                CommandLine commandLine = parser.parse(allCommandOptions, args);
                remainingArgs = commandLine.getArgs();
                if (remainingArgs != null && remainingArgs.length > 0) {
                    action = remainingArgs[0];
                }
                this.setLoggerLevel(commandLine.hasOption("trace"), commandLine.hasOption("debug"));
                if (commandLine.hasOption("u")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Username option is passed");
                    }
                    usernameInput = commandLine.getOptionValue("u");
                }
                if (commandLine.hasOption("p")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Password option is passed");
                    }
                    passwordInput = commandLine.getOptionValue("p");
                }
                if (commandLine.hasOption("help")) {
                    this.printHelp();
                    return 0;
                }
            }
            catch (ParseException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Error parsing arguments when trying to login", e);
                }
                System.out.println(e.getMessage());
                return 1;
            }
        }
        if (StringUtils.isNotBlank(action)) {
            boolean loginRequired;
            Command<StratosCommandContext> command;
            if (logger.isDebugEnabled()) {
                logger.debug("Action: {}", (Object)action);
            }
            if ((command = this.commands.get(action)) == null) {
                this.printHelp();
                return 1;
            }
            boolean bl = loginRequired = !"help".equals(action);
            if (loginRequired && logger.isDebugEnabled()) {
                logger.debug("Trying to login...");
            }
            if (loginRequired && !this.login(usernameInput, passwordInput, false)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Exiting from CLI. Login required but login might have failed: {}", (Object)action);
                }
                return 2;
            }
            try {
                String[] actionArgs = (String[])Arrays.copyOfRange(remainingArgs, 1, remainingArgs.length);
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing Action: {} {}", (Object)action, (Object)Arrays.asList(actionArgs));
                }
                int returnCode = command.execute(this.context, actionArgs);
                if (logger.isDebugEnabled()) {
                    logger.debug("Exiting with error code {} after executing action {}", (Object)returnCode, (Object)action);
                }
                System.exit(returnCode);
            }
            catch (CommandException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Error executing command: " + action, e);
                }
                return 2;
            }
        } else {
            if (!this.login(usernameInput, passwordInput, true)) {
                return 2;
            }
            System.out.println("Successfully Authenticated.");
            this.promptLoop();
        }
        return 0;
    }

    private boolean login(String usernameInput, String passwordInput, boolean validateLogin) {
        boolean success;
        block12: {
            if (StringUtils.isBlank(usernameInput) && StringUtils.isBlank(passwordInput)) {
                usernameInput = this.context.getString("STRATOS_USERNAME");
                passwordInput = this.context.getString("STRATOS_PASSWORD");
                if (logger.isDebugEnabled() && StringUtils.isNotBlank(usernameInput) && StringUtils.isNotBlank(passwordInput)) {
                    logger.debug("Found authentication details for {} from context", (Object)usernameInput);
                }
            }
            if (StringUtils.isBlank(usernameInput)) {
                usernameInput = this.getInput("Username");
            } else {
                System.out.format("Username: %s%n", usernameInput);
            }
            if (StringUtils.isBlank(passwordInput)) {
                passwordInput = this.getInput("Password", Character.valueOf('*'));
            }
            success = false;
            String stratosURL = null;
            stratosURL = this.context.getString("STRATOS_URL");
            if (this.username == null) {
                this.reader = null;
                this.reader = this.createConsoleReaderWhithoutArgs(usernameInput);
            }
            this.createAutocomplete();
            try {
                success = RestCommandLineService.getInstance().login(stratosURL, usernameInput, passwordInput, validateLogin);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block12;
                logger.error("Error when trying to login", e);
            }
        }
        if (success) {
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully Authenticated.");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Authentication failed.");
        }
        return success;
    }

    @Override
    protected int executeCommand(String line) {
        Command<StratosCommandContext> command;
        String[] tokens = new StrTokenizer(line).getTokenArray();
        String action = tokens[0];
        String[] actionArgs = Arrays.copyOfRange(tokens, 1, tokens.length);
        if (logger.isDebugEnabled()) {
            logger.debug("Executing command action: {}, Tokens: {}", (Object)action, (Object)tokens.length);
        }
        if ((command = this.commands.get(action)) == null) {
            System.out.println(action + ": command not found.");
            return 1;
        }
        try {
            return command.execute(this.context, actionArgs);
        }
        catch (CommandException e) {
            if (logger.isErrorEnabled()) {
                logger.error("Error executing command: " + action, e);
            }
            return 2;
        }
    }

    private boolean loadRequiredProperties() {
        UrlValidator urlValidator;
        if (logger.isDebugEnabled()) {
            logger.debug("Loading properties...");
        }
        String stratosURL = null;
        String username = null;
        String password = null;
        stratosURL = System.getenv("STRATOS_URL");
        username = System.getenv("STRATOS_USERNAME");
        password = System.getenv("STRATOS_PASSWORD");
        int slashCount = StringUtils.countMatches(stratosURL, "/");
        int colonCount = StringUtils.countMatches(stratosURL, ":");
        if (colonCount != 2 || slashCount != 3 && slashCount != 2) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invalid STRATOS_URL");
            }
            System.out.println("Invalid STRATOS_URL. Please enter correct STRATOS_URL");
            return false;
        }
        if (StringUtils.isBlank(stratosURL)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Required configuration not found.");
            }
            System.out.format("Could not find required \"%s\" variable in your environment.%n", "STRATOS_URL");
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Required configuration found. Validating {}", (Object)stratosURL);
        }
        if (!(urlValidator = new UrlValidator(new String[]{"https"}, 8L)).isValid(stratosURL)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Stratos Controller URL {} is not valid", (Object)stratosURL);
            }
            System.out.format("The \"%s\" variable in your environment is not a valid URL. You have provided \"%s\".%nPlease provide the Stratos Controller URL as follows%nhttps://<host>:<port>%n", "STRATOS_URL", stratosURL);
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Stratos Controller URL {} is valid.", (Object)stratosURL);
            logger.debug("Adding the values to context.");
        }
        this.context.put("STRATOS_URL", stratosURL);
        this.context.put("STRATOS_USERNAME", username);
        this.context.put("STRATOS_PASSWORD", password);
        return true;
    }

    private void setLoggerLevel(boolean trace, boolean debug) {
        org.apache.log4j.Logger logger = LogManager.getLogger(StratosApplication.class.getPackage().getName());
        if (logger != null && trace) {
            logger.setLevel(Level.TRACE);
            LogManager.getRootLogger().setLevel(Level.TRACE);
        } else if (logger != null && debug) {
            logger.setLevel(Level.DEBUG);
            LogManager.getRootLogger().setLevel(Level.DEBUG);
        }
    }

    public void printHelp(String action) {
        Command<StratosCommandContext> command = this.commands.get(action);
        if (command == null) {
            System.out.println(action + ": command not found. Help not available.");
            return;
        }
        System.out.println(command.getDescription());
        Options options = command.getOptions();
        if (options != null) {
            if (StringUtils.isNotBlank(command.getArgumentSyntax())) {
                this.printHelp(command.getName() + " " + command.getArgumentSyntax(), options);
            } else {
                this.printHelp(command.getName(), options);
            }
        } else {
            this.printUsage(command);
        }
    }

    public void printHelp() {
        this.printHelp("stratos", this.options);
        System.out.println("\n\nAvailable Commands: ");
        for (String action : this.commands.keySet()) {
            Command<StratosCommandContext> command = this.commands.get(action);
            if (command == null) continue;
            System.out.format("%-35s %s%n", command.getName(), command.getDescription());
        }
        System.out.println("\nFor help on a specific command type:\nhelp [command]");
    }

    private void printHelp(String commandLineSyntax, Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(commandLineSyntax, options, true);
    }

    public void printUsage(String action) {
        Command<StratosCommandContext> command = this.commands.get(action);
        if (command == null) {
            return;
        }
        this.printUsage(command);
    }

    private void printUsage(Command<StratosCommandContext> command) {
        Options options = command.getOptions();
        if (options != null) {
            if (StringUtils.isNotBlank(command.getArgumentSyntax())) {
                this.printUsage(command.getName() + " " + command.getArgumentSyntax(), options);
            } else {
                this.printUsage(command.getName(), options);
            }
        } else {
            System.out.print("usage: ");
            if (StringUtils.isNotBlank(command.getArgumentSyntax())) {
                System.out.println(command.getName() + " " + command.getArgumentSyntax());
            } else {
                System.out.println(command.getName());
            }
        }
    }

    private void printUsage(String commandLineSyntax, Options options) {
        PrintWriter writer = new PrintWriter(System.out);
        HelpFormatter usageFormatter = new HelpFormatter();
        usageFormatter.printUsage(writer, 80, commandLineSyntax, options);
        writer.flush();
    }
}

