/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.CommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDomainMappingCommand
implements Command<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(AddDomainMappingCommand.class);

    @Override
    public String getName() {
        return "add-domain-mapping";
    }

    @Override
    public String getDescription() {
        return "Map domain for the subscribed cartridge";
    }

    @Override
    public String getArgumentSyntax() {
        return "[Cartridge alias] [Domain]";
    }

    @Override
    public int execute(StratosCommandContext context, String[] args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length == 2) {
            String alias = args[0];
            String domain = args[1];
            if (logger.isDebugEnabled()) {
                logger.debug("Adding domain mapping {} for alias {}", (Object)domain, (Object)alias);
            }
            String domainToDisplay = null;
            domainToDisplay = CommandLineService.getInstance().addDomainMapping(domain, alias);
            if (StringUtils.isBlank(domainToDisplay)) {
                System.out.println("Error adding domain mapping.");
                return 1;
            }
            System.out.format("Your own domain is added. Please CNAME it to systems domain %s.%n", domainToDisplay);
            return 0;
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return null;
    }
}

