/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddTenantCommand
implements Command<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(AddTenantCommand.class);
    private final Options options = this.constructOptions();

    private Options constructOptions() {
        Options options = new Options();
        Option usernameOption = new Option("u", "username", true, "Tenant user name");
        usernameOption.setArgName("username");
        options.addOption(usernameOption);
        Option fistnameOption = new Option("f", "first-name", true, "Tenant first name");
        fistnameOption.setArgName("firstname");
        options.addOption(fistnameOption);
        Option lastnameOption = new Option("l", "last-name", true, "Tenant last name");
        lastnameOption.setArgName("lastname");
        options.addOption(lastnameOption);
        Option passwordOption = new Option("p", "password", true, "Tenant password");
        passwordOption.setArgName("password");
        options.addOption(passwordOption);
        Option domainOption = new Option("d", "domain-name", true, "Tenant domain");
        domainOption.setArgName("domain");
        options.addOption(domainOption);
        Option emailOption = new Option("e", "email", true, "Tenant email");
        emailOption.setArgName("email");
        options.addOption(emailOption);
        return options;
    }

    @Override
    public String getName() {
        return "create-tenant";
    }

    @Override
    public String getDescription() {
        return "Add new tenant";
    }

    @Override
    public String getArgumentSyntax() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length > 0) {
            String admin = null;
            String firstName = null;
            String lastaName = null;
            String password = null;
            String domain = null;
            String email = null;
            GnuParser parser = new GnuParser();
            try {
                CommandLine commandLine = parser.parse(this.options, args);
                if (logger.isDebugEnabled()) {
                    logger.debug("Add tenant");
                }
                if (commandLine.hasOption("u")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Username option is passed");
                    }
                    admin = commandLine.getOptionValue("u");
                }
                if (commandLine.hasOption("f")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("First name option is passed");
                    }
                    firstName = commandLine.getOptionValue("f");
                }
                if (commandLine.hasOption("l")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Last name option is passed");
                    }
                    lastaName = commandLine.getOptionValue("l");
                }
                if (commandLine.hasOption("p")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Password option is passed");
                    }
                    password = commandLine.getOptionValue("p");
                }
                if (commandLine.hasOption("d")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Domain name option is passed");
                    }
                    domain = commandLine.getOptionValue("d");
                }
                if (commandLine.hasOption("e")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Email option is passed");
                    }
                    email = commandLine.getOptionValue("e");
                }
                if (admin == null || firstName == null || lastaName == null || password == null || domain == null || email == null) {
                    System.out.println("usage: " + this.getName() + " [-u <user name>] [-f <first name>] [-l <last name>] [-p <password>] [-d <domain name>] [-e <email>]");
                    return 1;
                }
                RestCommandLineService.getInstance().addTenant(admin, firstName, lastaName, password, domain, email);
                return 0;
            }
            catch (ParseException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Error parsing arguments", e);
                }
                System.out.println(e.getMessage());
                return 1;
            }
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }
}

