/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoscalingPolicyDeploymentCommand
implements Command<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(AutoscalingPolicyDeploymentCommand.class);
    private final Options options = this.constructOptions();

    private Options constructOptions() {
        Options options = new Options();
        Option resourcePath = new Option("p", "resource-path", true, "Autoscaling policy deployment resource path");
        resourcePath.setArgName("resource path");
        options.addOption(resourcePath);
        return options;
    }

    @Override
    public String getName() {
        return "deploy-autoscaling-policy";
    }

    @Override
    public String getDescription() {
        return "Add new autoscaling policy deployment";
    }

    @Override
    public String getArgumentSyntax() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length > 0) {
            String resourcePath = null;
            String autoscalingPolicyDeployment = null;
            GnuParser parser = new GnuParser();
            try {
                CommandLine commandLine = parser.parse(this.options, args);
                if (logger.isDebugEnabled()) {
                    logger.debug("Autoscaling policy deployment");
                }
                if (commandLine.hasOption("p")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Resource path option is passed");
                    }
                    resourcePath = commandLine.getOptionValue("p");
                    autoscalingPolicyDeployment = this.readResource(resourcePath);
                }
                if (resourcePath == null) {
                    System.out.println("usage: " + this.getName() + " [-p <resource path>]");
                    return 1;
                }
                RestCommandLineService.getInstance().deployAutoscalingPolicy(autoscalingPolicyDeployment);
                return 0;
            }
            catch (ParseException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Error parsing arguments", e);
                }
                System.out.println(e.getMessage());
                return 1;
            }
            catch (IOException e) {
                System.out.println("Invalid resource path");
                return 1;
            }
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResource(String fileName) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        try {
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            br.close();
        }
    }

    @Override
    public Options getOptions() {
        return this.options;
    }
}

