/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.Options;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescribeAutoScalingPolicyCommand
implements Command<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(DescribeAutoScalingPolicyCommand.class);

    @Override
    public String getName() {
        return "describe-autoscaling-policy";
    }

    @Override
    public String getDescription() {
        return "Describing the autoscaling policy";
    }

    @Override
    public String getArgumentSyntax() {
        return "[ID]";
    }

    @Override
    public Options getOptions() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length == 1) {
            String id = args[0];
            if (logger.isDebugEnabled()) {
                logger.debug("Getting Autoscale policy info {}", (Object)id);
            }
            RestCommandLineService.getInstance().describeAutoScalingPolicy(id);
            return 0;
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }
}

