/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.Options;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpCommand
implements Command<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(HelpCommand.class);

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public String getDescription() {
        return "Help for commands";
    }

    @Override
    public String getArgumentSyntax() {
        return "[command]";
    }

    @Override
    public int execute(StratosCommandContext context, String[] args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} command...", (Object)this.getName());
        }
        if (args == null || args.length == 0) {
            context.getStratosApplication().printHelp();
            return 0;
        }
        if (args != null && args.length == 1) {
            context.getStratosApplication().printHelp(args[0]);
            return 0;
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return null;
    }
}

