/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListMemberCommand
implements Command<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(ListMemberCommand.class);
    private final Options options = this.constructOptions();

    private Options constructOptions() {
        Options options = new Options();
        Option type = new Option("t", "cartridge-type", true, "Cartridge Type");
        type.setArgName("cartridge-type");
        options.addOption(type);
        Option alias = new Option("a", "alias", true, "subscription alias");
        alias.setArgName("alias");
        options.addOption(alias);
        return options;
    }

    @Override
    public String getName() {
        return "list-members";
    }

    @Override
    public String getDescription() {
        return "List of members in a cluster";
    }

    @Override
    public String getArgumentSyntax() {
        return null;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length > 0) {
            String type = null;
            String alias = null;
            GnuParser parser = new GnuParser();
            try {
                CommandLine commandLine = parser.parse(this.options, args);
                if (logger.isDebugEnabled()) {
                    logger.debug("Subscribing to {} cartridge with alias {}", (Object)type, (Object)alias);
                }
                if (commandLine.hasOption("t")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Autoscaling policy option is passed");
                    }
                    type = commandLine.getOptionValue("t");
                }
                if (commandLine.hasOption("a")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Deployment policy option is passed");
                    }
                    alias = commandLine.getOptionValue("a");
                }
                if (type == null) {
                    System.out.println("Cartridge type is required.");
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                if (alias == null) {
                    System.out.println("alis is required...");
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                RestCommandLineService.getInstance().listMembersOfCluster(type, alias);
                return 0;
            }
            catch (ParseException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Error parsing arguments", e);
                }
                System.out.println(e.getMessage());
                return 1;
            }
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }
}

