/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSubscribedCartridgesCommand
implements Command<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(ListSubscribedCartridgesCommand.class);
    private final Options options = this.constructOptions();

    private Options constructOptions() {
        Options options = new Options();
        Option fullOption = new Option("f", "full", false, "Display extra details");
        options.addOption(fullOption);
        return options;
    }

    @Override
    public String getName() {
        return "list-subscribed-cartridges";
    }

    @Override
    public String getDescription() {
        return "List subscribed cartridges with summarized details";
    }

    @Override
    public String getArgumentSyntax() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} command...", (Object)this.getName());
        }
        if (args == null || args.length == 0) {
            RestCommandLineService.getInstance().listSubscribedCartridges(false);
            return 0;
        }
        if (args != null && args.length > 0) {
            String[] remainingArgs = null;
            boolean full = false;
            GnuParser parser = new GnuParser();
            try {
                CommandLine commandLine = parser.parse(this.options, args);
                remainingArgs = commandLine.getArgs();
                if (remainingArgs != null && remainingArgs.length != 0) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                if (commandLine.hasOption("f")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Full option is passed");
                    }
                    full = true;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Listing subscribed cartridges, Full Option: {}", (Object)full);
                }
                RestCommandLineService.getInstance().listSubscribedCartridges(full);
                return 0;
            }
            catch (ParseException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Error parsing arguments", e);
                }
                System.out.println(e.getMessage());
                return 1;
            }
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }
}

