/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.commands.ListSubscribedCartridgesCommand;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeCommand
implements Command<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(ListSubscribedCartridgesCommand.class);
    private final Options options = this.constructOptions();

    private Options constructOptions() {
        Options options = new Options();
        Option autoscaling = new Option("ap", "autoscaling-policy", true, "Auto-scaling policy");
        autoscaling.setArgName("auto-scaling-policy");
        options.addOption(autoscaling);
        Option deployment = new Option("dp", "deployment-policy", true, "Deployment-policy");
        deployment.setArgName("deployment-policy");
        options.addOption(deployment);
        Option removeOnTermination = new Option("t", "remove-on-termination", true, "Remove-on-termination");
        removeOnTermination.setArgName("remove-on-termination");
        options.addOption(removeOnTermination);
        Option size = new Option("v", "volume-size", true, "Volume-size");
        size.setArgName("volume-size");
        options.addOption(size);
        Option persistance = new Option("pv", "persistance-volume", true, "Persistance-volume");
        persistance.setArgName("persistance-volume");
        options.addOption(persistance);
        Option urlOption = new Option("r", "repo-url", true, "GIT repository URL");
        urlOption.setArgName("url");
        options.addOption(urlOption);
        Option usernameOption = new Option("u", "username", true, "GIT repository username");
        usernameOption.setArgName("username");
        options.addOption(usernameOption);
        Option passwordOption = new Option("p", "password", true, "GIT repository password");
        passwordOption.setArgName("password");
        passwordOption.setOptionalArg(true);
        options.addOption(passwordOption);
        Option upstreamCommitsEnabledOption = new Option("cm", "enable-commits", true, "Enable Git commit upstream");
        upstreamCommitsEnabledOption.setArgName("enable-commits");
        upstreamCommitsEnabledOption.setOptionalArg(true);
        options.addOption(upstreamCommitsEnabledOption);
        return options;
    }

    @Override
    public String getName() {
        return "subscribe-cartridge";
    }

    @Override
    public String getDescription() {
        return "Subscribe to a cartridge";
    }

    @Override
    public String getArgumentSyntax() {
        return "[Cartridge type] [Cartridge alias]";
    }

    @Override
    public int execute(StratosCommandContext context, String[] args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length > 0) {
            String[] remainingArgs = null;
            String type = null;
            String alias = null;
            Object policy = null;
            String asPolicy = null;
            String depPolicy = null;
            String repoURL = null;
            String username = "";
            String password = "";
            String size = null;
            boolean removeOnTermination = false;
            boolean privateRepo = false;
            boolean persistanceMapping = false;
            boolean commitsEnabled = false;
            GnuParser parser = new GnuParser();
            try {
                CommandLine commandLine = parser.parse(this.options, args);
                remainingArgs = commandLine.getArgs();
                if (remainingArgs == null || remainingArgs.length != 2) {
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                type = remainingArgs[0];
                alias = remainingArgs[1];
                if (logger.isDebugEnabled()) {
                    logger.debug("Subscribing to {} cartridge with alias {}", (Object)type, (Object)alias);
                }
                if (commandLine.hasOption("ap")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Autoscaling policy option is passed");
                    }
                    asPolicy = commandLine.getOptionValue("ap");
                }
                if (commandLine.hasOption("dp")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Deployment policy option is passed");
                    }
                    depPolicy = commandLine.getOptionValue("dp");
                }
                if (commandLine.hasOption("r")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("RepoURL option is passed");
                    }
                    repoURL = commandLine.getOptionValue("r");
                }
                if (commandLine.hasOption("v")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Volume size option is passed");
                    }
                    size = commandLine.getOptionValue("v");
                }
                if (commandLine.hasOption("t")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Remove on termination option is passed");
                    }
                    removeOnTermination = true;
                }
                if (commandLine.hasOption("pv")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Persistance volume option is passed");
                    }
                    persistanceMapping = true;
                }
                if (commandLine.hasOption("u")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Username option is passed");
                    }
                    username = commandLine.getOptionValue("u");
                }
                if (commandLine.hasOption("p")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Password option is passed");
                    }
                    password = commandLine.getOptionValue("p");
                }
                if (commandLine.hasOption("cm")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Upstream git commits are enabled");
                    }
                    commitsEnabled = true;
                }
                if (depPolicy == null) {
                    System.out.println("Deployment policy is required.");
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                if (asPolicy == null) {
                    System.out.println("Autoscaling policy is required.");
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                if (!persistanceMapping && (size != null || removeOnTermination)) {
                    System.out.println("You have to enable persistance mapping in cartridge subscription");
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                if (StringUtils.isNotBlank(username) && StringUtils.isBlank(password)) {
                    password = context.getApplication().getInput("GIT Repository Password", Character.valueOf('*'));
                }
                RestCommandLineService.getInstance().subscribe(type, alias, repoURL, privateRepo, username, password, asPolicy, depPolicy, size, removeOnTermination, persistanceMapping, commitsEnabled);
                return 0;
            }
            catch (ParseException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Error parsing arguments", e);
                }
                System.out.println(e.getMessage());
                return 1;
            }
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }
}

