/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.Options;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncCommand
implements Command<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(SyncCommand.class);

    @Override
    public String getName() {
        return "sync";
    }

    @Override
    public String getDescription() {
        return "Synchronize GIT repository for the subscribed cartridge";
    }

    @Override
    public String getArgumentSyntax() {
        return "[Cartridge alias]";
    }

    @Override
    public int execute(StratosCommandContext context, String[] args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length == 1) {
            String alias = args[0];
            if (logger.isDebugEnabled()) {
                logger.debug("Synchronizing repository for alias {}", (Object)alias);
            }
            RestCommandLineService.getInstance().sync(alias);
            return 0;
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return null;
    }
}

