/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.Options;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndeployCartridgeDefinitionCommand
implements Command<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(UndeployCartridgeDefinitionCommand.class);

    @Override
    public String getName() {
        return "undeploy-cartridge";
    }

    @Override
    public String getDescription() {
        return "Undeploy cartridge definition";
    }

    @Override
    public String getArgumentSyntax() {
        return "[Cartridge Type]";
    }

    @Override
    public Options getOptions() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length == 1) {
            String id = args[0];
            if (logger.isDebugEnabled()) {
                logger.debug("Getting undeploy cartridge definition info {}", (Object)id);
            }
            RestCommandLineService.getInstance().undeployCartrigdeDefinition(id);
            return 0;
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }
}

