/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.Options;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndeployServiceDefinitionCommand
implements Command<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(UndeployServiceDefinitionCommand.class);

    @Override
    public String getName() {
        return "undeploy-service";
    }

    @Override
    public String getDescription() {
        return "Undeploy Multitenant Service";
    }

    @Override
    public String getArgumentSyntax() {
        return "[Service Type]";
    }

    @Override
    public Options getOptions() {
        return null;
    }

    @Override
    public int execute(StratosCommandContext context, String[] args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length == 1) {
            String id = args[0];
            if (logger.isDebugEnabled()) {
                logger.debug("Getting undeploy miltitenant service info {}", (Object)id);
            }
            RestCommandLineService.getInstance().undeployService(id);
            return 0;
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }
}

