/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.RestCommandLineService;
import org.apache.stratos.cli.StratosCommandContext;
import org.apache.stratos.cli.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsubscribeCommand
implements Command<StratosCommandContext> {
    private static final Logger logger = LoggerFactory.getLogger(UnsubscribeCommand.class);
    private final Options options = this.constructOptions();

    private Options constructOptions() {
        Options options = new Options();
        Option forceOption = new Option("f", "force", false, "Never prompt for confirmation");
        options.addOption(forceOption);
        return options;
    }

    @Override
    public String getName() {
        return "unsubscribe-cartridge";
    }

    @Override
    public String getDescription() {
        return "Unsubscribe from a subscribed cartridge";
    }

    @Override
    public String getArgumentSyntax() {
        return "[Cartridge alias]";
    }

    @Override
    public int execute(StratosCommandContext context, String[] args) throws CommandException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing {} command...", (Object)this.getName());
        }
        if (args != null && args.length > 0) {
            String[] remainingArgs = null;
            String alias = null;
            boolean force = false;
            GnuParser parser = new GnuParser();
            try {
                CommandLine commandLine = parser.parse(this.options, args);
                remainingArgs = commandLine.getArgs();
                if (remainingArgs == null || remainingArgs.length != 1) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Unsubscribe: not enough arguments");
                    }
                    context.getStratosApplication().printUsage(this.getName());
                    return 1;
                }
                alias = remainingArgs[0];
                if (commandLine.hasOption("f")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Force option is passed");
                    }
                    force = true;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Unsubscribing {}, Force Option: {}", (Object)alias, (Object)force);
                }
                if (force || context.getApplication().getConfirmation("Are you sure you want to unsubscribe?")) {
                    System.out.format("Unsubscribing the cartridge %s%n", alias);
                    RestCommandLineService.getInstance().unsubscribe(alias);
                }
                return 0;
            }
            catch (ParseException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Error parsing arguments", e);
                }
                System.out.println(e.getMessage());
                return 1;
            }
        }
        context.getStratosApplication().printUsage(this.getName());
        return 1;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }
}

