/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.completer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrTokenizer;
import org.apache.stratos.cli.Command;
import org.apache.stratos.cli.StratosApplication;
import org.apache.stratos.cli.StratosCommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandCompleter
implements Completer {
    private static final Logger logger = LoggerFactory.getLogger(StratosApplication.class);
    private final Map<String, Collection<String>> argumentMap;
    private final Completer helpCommandCompleter;
    private final Completer defaultCommandCompleter;

    public CommandCompleter(Map<String, Command<StratosCommandContext>> commands) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating auto complete for {} commands", (Object)commands.size());
        }
        this.argumentMap = new HashMap<String, Collection<String>>();
        this.defaultCommandCompleter = new StringsCompleter(commands.keySet());
        this.helpCommandCompleter = new ArgumentCompleter(new StringsCompleter("help"), this.defaultCommandCompleter);
        for (String action : commands.keySet()) {
            Command<StratosCommandContext> command = commands.get(action);
            Options commandOptions = command.getOptions();
            if (commandOptions == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Creating argument completer for command: {}", (Object)action);
            }
            ArrayList<String> arguments = new ArrayList<String>();
            Collection allOptions = commandOptions.getOptions();
            for (Object o : allOptions) {
                Option option = (Option)o;
                String longOpt = option.getLongOpt();
                String opt = option.getOpt();
                if (StringUtils.isNotBlank(longOpt)) {
                    arguments.add("--" + longOpt);
                    continue;
                }
                if (!StringUtils.isNotBlank(opt)) continue;
                arguments.add("-" + opt);
            }
            this.argumentMap.put(action, arguments);
        }
    }

    @Override
    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        if (logger.isTraceEnabled()) {
            logger.trace("Buffer: {}, cursor: {}", (Object)buffer, (Object)cursor);
            logger.trace("Candidates {}", (Object)candidates);
        }
        if (StringUtils.isNotBlank(buffer)) {
            StrTokenizer strTokenizer = new StrTokenizer(buffer);
            String action = strTokenizer.next();
            Collection<String> arguments = this.argumentMap.get(action);
            if (arguments != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Arguments found for {}, Tokens: {}", (Object)action, (Object)strTokenizer.getTokenList());
                    logger.trace("Arguments for {}: {}", (Object)action, (Object)arguments);
                }
                ArrayList<String> args = new ArrayList<String>(arguments);
                ArrayList<Completer> completers = new ArrayList<Completer>();
                for (String token : strTokenizer.getTokenList()) {
                    boolean argContains = arguments.contains(token);
                    if (token.startsWith("-") && !argContains) continue;
                    if (argContains) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Removing argument {}", (Object)token);
                        }
                        args.remove(token);
                    }
                    completers.add(new StringsCompleter(token));
                }
                completers.add(new StringsCompleter(args));
                ArgumentCompleter completer = new ArgumentCompleter(completers);
                return completer.complete(buffer, cursor, candidates);
            }
            if ("help".equals(action)) {
                return this.helpCommandCompleter.complete(buffer, cursor, candidates);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Using Default Completer...");
        }
        return this.defaultCommandCompleter.complete(buffer, cursor, candidates);
    }
}

