/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cli.utils;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.stratos.cli.utils.RowMapper;

public class CommandLineUtils {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("Resources");

    public static <T> void printTable(T[] data, RowMapper<T> mapper, String ... headers) {
        int i;
        if (data == null) {
            return;
        }
        int columns = headers.length;
        int rows = data.length + 1;
        String[][] table = new String[rows][columns];
        table[0] = headers;
        for (int i2 = 0; i2 < data.length; ++i2) {
            T t = data[i2];
            table[i2 + 1] = mapper.getData(t);
        }
        int[] lengths = new int[columns];
        for (int i3 = 0; i3 < table.length; ++i3) {
            for (int j = 0; j < table[i3].length; ++j) {
                lengths[j] = Math.max(table[i3][j].length(), lengths[j]);
            }
        }
        String[] borders = new String[lengths.length];
        String[] formats = new String[lengths.length];
        for (i = 0; i < lengths.length; ++i) {
            boolean finalColumn;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("+");
            for (int j = 0; j < lengths[i] + 2; ++j) {
                stringBuilder.append("-");
            }
            boolean bl = finalColumn = i + 1 == lengths.length;
            if (finalColumn) {
                stringBuilder.append("+\n");
            }
            borders[i] = stringBuilder.toString();
            formats[i] = "| %1$-" + lengths[i] + "s " + (finalColumn ? "|\n" : "");
        }
        for (i = 0; i < table.length; ++i) {
            int j;
            for (j = 0; j < table[i].length; ++j) {
                System.out.print(borders[j]);
            }
            for (j = 0; j < table[i].length; ++j) {
                System.out.format(formats[j], table[i][j]);
            }
            if (i + 1 != table.length) continue;
            for (j = 0; j < table[i].length; ++j) {
                System.out.print(borders[j]);
            }
        }
    }

    public static String getMessage(String key, Object ... args) {
        String message = BUNDLE.getString(key);
        if (args != null && args.length > 0) {
            message = MessageFormat.format(message, args);
        }
        return message;
    }
}

