/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.java;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.template.BaseTemplateEngine;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.components.template.TemplateRenderingContext;
import org.apache.struts2.views.java.Theme;
import org.apache.struts2.views.java.simple.SimpleTheme;

public class JavaTemplateEngine
extends BaseTemplateEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JavaTemplateEngine.class);
    private Themes themes = new Themes(){
        {
            this.add(new SimpleTheme());
        }
    };

    protected String getSuffix() {
        return "java";
    }

    public void renderTemplate(TemplateRenderingContext templateContext) throws Exception {
        Template t = templateContext.getTemplate();
        Theme theme = this.themes.get(t.getTheme());
        if (theme == null) {
            throw new StrutsException("Cannot render tag [" + t.getName() + "] because theme [" + t.getTheme() + "] was not found.");
        }
        theme.renderTag(t.getName(), templateContext);
    }

    @Inject(value="struts.javatemplates.customThemes", required=false)
    public void setThemeClasses(String themeClasses) {
        StringTokenizer customThemes = new StringTokenizer(themeClasses, ",");
        while (customThemes.hasMoreTokens()) {
            String themeClass = customThemes.nextToken().trim();
            try {
                LOG.info("Registering custom theme '" + themeClass + "' to javatemplates engine", new String[0]);
                this.themes.add((Theme)ClassLoaderUtil.loadClass((String)themeClass, ((Object)((Object)this)).getClass()).newInstance());
            }
            catch (ClassCastException cce) {
                LOG.error("Invalid java them class '" + themeClass + "'. Class does not implement 'org.apache.struts2.views.java.Theme' interface", new String[0]);
            }
            catch (ClassNotFoundException cnf) {
                LOG.error("Invalid java theme class '" + themeClass + "'. Class not found", new String[0]);
            }
            catch (Exception e) {
                LOG.error("Could not find messages file " + themeClass + ".properties. Skipping", new String[0]);
            }
        }
    }

    private class Themes {
        private HashMap<String, Theme> themes = new HashMap();

        private Themes() {
        }

        public void add(Theme theme) {
            this.themes.put(theme.getName(), theme);
        }

        public Theme get(String name) {
            return this.themes.get(name);
        }
    }
}

