/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.plexus;

import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.plexus.PlexusObjectFactory;
import org.apache.struts2.plexus.PlexusUtils;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;

public class PlexusLifecycleListener
implements ServletContextListener,
HttpSessionListener {
    private static final Log log = LogFactory.getLog(PlexusObjectFactory.class);
    private static boolean loaded = false;
    public static final String KEY = "struts.plexus.container";

    public static boolean isLoaded() {
        return loaded;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        loaded = true;
        try {
            DefaultPlexusContainer pc = new DefaultPlexusContainer();
            PlexusUtils.configure((PlexusContainer)pc, "plexus-application.xml");
            ServletContext ctx = servletContextEvent.getServletContext();
            ctx.setAttribute(KEY, (Object)pc);
            pc.initialize();
            pc.start();
        }
        catch (Exception e) {
            log.error((Object)"Error initializing plexus container (scope: application)", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            ServletContext ctx = servletContextEvent.getServletContext();
            PlexusContainer pc = (PlexusContainer)ctx.getAttribute(KEY);
            pc.dispose();
        }
        catch (Exception e) {
            log.error((Object)"Error disposing plexus container (scope: application)", (Throwable)e);
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        try {
            HttpSession session = httpSessionEvent.getSession();
            ServletContext ctx = session.getServletContext();
            PlexusContainer parent = (PlexusContainer)ctx.getAttribute(KEY);
            PlexusContainer child = parent.createChildContainer("session", Collections.EMPTY_LIST, Collections.EMPTY_MAP);
            session.setAttribute(KEY, (Object)child);
            PlexusUtils.configure(child, "plexus-session.xml");
            child.initialize();
            child.start();
        }
        catch (Exception e) {
            log.error((Object)"Error initializing plexus container (scope: session)", (Throwable)e);
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        try {
            HttpSession session = httpSessionEvent.getSession();
            PlexusContainer child = (PlexusContainer)session.getAttribute(KEY);
            child.dispose();
        }
        catch (Exception e) {
            log.error((Object)"Error initializing plexus container (scope: session)", (Throwable)e);
        }
    }
}

