/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.util;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.PortletMode;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.xwork.StringUtils;
import org.apache.struts2.StrutsException;
import org.apache.struts2.portlet.context.PortletActionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletUrlHelper {
    public static final String ENCODING = "UTF-8";
    private static final Logger LOG = LoggerFactory.getLogger(PortletUrlHelper.class);

    public static String buildUrl(String action, String namespace, String method, Map params, String type, String mode, String state) {
        return PortletUrlHelper.buildUrl(action, namespace, method, params, null, type, mode, state, true, true);
    }

    public static String buildUrl(String action, String namespace, String method, Map params, String scheme, String type, String portletMode, String windowState, boolean includeContext, boolean encodeResult) {
        StringBuffer resultingAction = new StringBuffer();
        RenderRequest request = PortletActionContext.getRenderRequest();
        RenderResponse response = PortletActionContext.getRenderResponse();
        LOG.debug("Creating url. Action = " + action + ", Namespace = " + namespace + ", Type = " + type, new String[0]);
        namespace = PortletUrlHelper.prependNamespace(namespace, portletMode);
        if (StringUtils.isEmpty((String)portletMode)) {
            portletMode = PortletActionContext.getRenderRequest().getPortletMode().toString();
        }
        String result = null;
        int paramStartIndex = action.indexOf(63);
        if (paramStartIndex > 0) {
            String value = action;
            action = value.substring(0, value.indexOf(63));
            String queryStr = value.substring(paramStartIndex + 1);
            StringTokenizer tok = new StringTokenizer(queryStr, "&");
            while (tok.hasMoreTokens()) {
                String paramVal = tok.nextToken();
                String key = paramVal.substring(0, paramVal.indexOf(61));
                String val = paramVal.substring(paramVal.indexOf(61) + 1);
                params.put(key, new String[]{val});
            }
        }
        if (StringUtils.isNotEmpty((String)namespace)) {
            resultingAction.append(namespace);
            if (!action.startsWith("/") && !namespace.endsWith("/")) {
                resultingAction.append("/");
            }
        }
        resultingAction.append(action);
        if (StringUtils.isNotEmpty((String)method)) {
            resultingAction.append("!").append(method);
        }
        LOG.debug("Resulting actionPath: " + resultingAction, new String[0]);
        params.put("struts.portlet.action", new String[]{resultingAction.toString()});
        PortletURL url = null;
        if ("action".equalsIgnoreCase(type)) {
            LOG.debug("Creating action url", new String[0]);
            url = response.createActionURL();
        } else {
            LOG.debug("Creating render url", new String[0]);
            url = response.createRenderURL();
        }
        params.put("struts.portlet.mode", portletMode);
        url.setParameters(PortletUrlHelper.ensureParamsAreStringArrays(params));
        if ("HTTPS".equalsIgnoreCase(scheme)) {
            try {
                url.setSecure(true);
            }
            catch (PortletSecurityException e) {
                LOG.error("Cannot set scheme to https", (Throwable)e, new String[0]);
            }
        }
        try {
            url.setPortletMode(PortletUrlHelper.getPortletMode(request, portletMode));
            url.setWindowState(PortletUrlHelper.getWindowState(request, windowState));
        }
        catch (Exception e) {
            LOG.error("Unable to set mode or state:" + e.getMessage(), (Throwable)e, new String[0]);
        }
        result = url.toString();
        if (result.indexOf("&amp;") >= 0) {
            result = result.replace("&amp;", "&");
        }
        return result;
    }

    private static String prependNamespace(String namespace, String portletMode) {
        StringBuffer sb = new StringBuffer();
        PortletMode mode = PortletActionContext.getRenderRequest().getPortletMode();
        if (StringUtils.isNotEmpty((String)portletMode)) {
            mode = new PortletMode(portletMode);
        }
        String portletNamespace = PortletActionContext.getPortletNamespace();
        String modeNamespace = (String)PortletActionContext.getModeNamespaceMap().get(mode);
        LOG.debug("PortletNamespace: " + portletNamespace + ", modeNamespace: " + modeNamespace, new String[0]);
        if (StringUtils.isNotEmpty((String)portletNamespace)) {
            sb.append(portletNamespace);
        }
        if (StringUtils.isNotEmpty((String)modeNamespace)) {
            if (!modeNamespace.startsWith("/")) {
                sb.append("/");
            }
            sb.append(modeNamespace);
        }
        if (StringUtils.isNotEmpty((String)namespace)) {
            if (!namespace.startsWith("/")) {
                sb.append("/");
            }
            sb.append(namespace);
        }
        LOG.debug("Resulting namespace: " + sb, new String[0]);
        return sb.toString();
    }

    public static String buildResourceUrl(String value, Map<String, Object> params) {
        StringBuffer sb = new StringBuffer();
        if (!value.startsWith("/")) {
            sb.append("/");
        }
        sb.append(value);
        if (params != null && params.size() > 0) {
            sb.append("?");
            Iterator<Map.Entry<String, Object>> it = params.entrySet().iterator();
            try {
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    sb.append(URLEncoder.encode(entry.getKey(), ENCODING)).append("=");
                    sb.append(URLEncoder.encode(entry.getValue().toString(), ENCODING));
                    if (!it.hasNext()) continue;
                    sb.append("&");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new StrutsException("Encoding UTF-8 not found");
            }
        }
        RenderResponse resp = PortletActionContext.getRenderResponse();
        RenderRequest req = PortletActionContext.getRenderRequest();
        return resp.encodeURL(req.getContextPath() + sb.toString());
    }

    public static Map ensureParamsAreStringArrays(Map<String, Object> params) {
        LinkedHashMap<String, String[]> result = null;
        if (params != null) {
            result = new LinkedHashMap<String, String[]>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                Object val = entry.getValue();
                if (val instanceof String[]) {
                    result.put(entry.getKey(), (String[])val);
                    continue;
                }
                result.put(entry.getKey(), new String[]{val.toString()});
            }
        }
        return result;
    }

    private static WindowState getWindowState(RenderRequest portletReq, String windowState) {
        WindowState state = portletReq.getWindowState();
        if (StringUtils.isNotEmpty((String)windowState)) {
            state = portletReq.getWindowState();
            if ("maximized".equalsIgnoreCase(windowState)) {
                state = WindowState.MAXIMIZED;
            } else if ("normal".equalsIgnoreCase(windowState)) {
                state = WindowState.NORMAL;
            } else if ("minimized".equalsIgnoreCase(windowState)) {
                state = WindowState.MINIMIZED;
            }
        }
        if (state == null) {
            state = WindowState.NORMAL;
        }
        return state;
    }

    private static PortletMode getPortletMode(RenderRequest portletReq, String portletMode) {
        PortletMode mode = portletReq.getPortletMode();
        if (StringUtils.isNotEmpty((String)portletMode)) {
            mode = portletReq.getPortletMode();
            if ("edit".equalsIgnoreCase(portletMode)) {
                mode = PortletMode.EDIT;
            } else if ("view".equalsIgnoreCase(portletMode)) {
                mode = PortletMode.VIEW;
            } else if ("help".equalsIgnoreCase(portletMode)) {
                mode = PortletMode.HELP;
            }
        }
        if (mode == null) {
            mode = PortletMode.VIEW;
        }
        return mode;
    }
}

