/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.result;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.StrutsResultSupport;
import org.apache.struts2.portlet.PortletActionConstants;
import org.apache.struts2.portlet.context.PortletActionContext;
import org.apache.struts2.portlet.result.PortletResultHelper;
import org.apache.struts2.portlet.result.PortletResultHelperJSR168;
import org.apache.struts2.portlet.result.PortletResultHelperJSR286;

public class PortletResult
extends StrutsResultSupport
implements PortletActionConstants {
    private static final long serialVersionUID = 434251393926178567L;
    private boolean useDispatcherServlet;
    private String dispatcherServletName = "Struts2PortletDispatcherServlet";
    private static final Logger LOG = LoggerFactory.getLogger(PortletResult.class);
    private String contentType = "text/html";
    private String title;
    protected PortletMode portletMode;
    PortletResultHelper resultHelper;

    public PortletResult() {
        this.determineResultHelper();
    }

    public PortletResult(String location) {
        super(location);
        this.determineResultHelper();
    }

    private void determineResultHelper() {
        this.resultHelper = PortletActionContext.isJSR268Supported() ? new PortletResultHelperJSR286() : new PortletResultHelperJSR168();
    }

    public void doExecute(String finalLocation, ActionInvocation actionInvocation) throws Exception {
        if (PortletActionContext.isRender() || PortletActionContext.isResource()) {
            this.executeMimeResult(finalLocation);
        } else if (PortletActionContext.isAction() || PortletActionContext.isEvent()) {
            this.executeActionResult(finalLocation, actionInvocation);
        } else {
            this.executeRegularServletResult(finalLocation, actionInvocation);
        }
    }

    private void executeRegularServletResult(String finalLocation, ActionInvocation actionInvocation) throws ServletException, IOException {
        ServletContext ctx = ServletActionContext.getServletContext();
        HttpServletRequest req = ServletActionContext.getRequest();
        HttpServletResponse res = ServletActionContext.getResponse();
        try {
            ctx.getRequestDispatcher(finalLocation).include((ServletRequest)req, (ServletResponse)res);
        }
        catch (ServletException e) {
            LOG.error("ServletException including " + finalLocation, (Throwable)e, new String[0]);
            throw e;
        }
        catch (IOException e) {
            LOG.error("IOException while including result '" + finalLocation + "'", (Throwable)e, new String[0]);
            throw e;
        }
    }

    protected void executeActionResult(String finalLocation, ActionInvocation invocation) throws Exception {
        String phase;
        String string = phase = PortletActionContext.isEvent() ? "Event" : "Action";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing result in " + phase + " phase", new String[0]);
        }
        Map sessionMap = invocation.getInvocationContext().getSession();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting event render parameter: " + finalLocation, new String[0]);
        }
        if (finalLocation.indexOf(63) != -1) {
            this.convertQueryParamsToRenderParams(finalLocation.substring(finalLocation.indexOf(63) + 1));
            finalLocation = finalLocation.substring(0, finalLocation.indexOf(63));
        }
        PortletResponse response = PortletActionContext.getResponse();
        if (finalLocation.endsWith(".action")) {
            finalLocation = finalLocation.substring(0, finalLocation.lastIndexOf("."));
            this.resultHelper.setRenderParameter(response, "struts.portlet.action", finalLocation);
        } else {
            this.resultHelper.setRenderParameter(response, "struts.portlet.action", "renderDirect");
            sessionMap.put("struts.portlet.renderDirectLocation", finalLocation);
        }
        if (this.portletMode != null) {
            this.resultHelper.setPortletMode(response, this.portletMode);
            this.resultHelper.setRenderParameter(response, "struts.portlet.mode", this.portletMode.toString());
        } else {
            this.resultHelper.setRenderParameter(response, "struts.portlet.mode", PortletActionContext.getRequest().getPortletMode().toString());
        }
    }

    protected void convertQueryParamsToRenderParams(String queryParams) {
        StringTokenizer tok = new StringTokenizer(queryParams, "&");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            String key = token.substring(0, token.indexOf(61));
            String value = token.substring(token.indexOf(61) + 1);
            this.resultHelper.setRenderParameter(PortletActionContext.getResponse(), key, value);
        }
    }

    protected void executeMimeResult(String finalLocation) throws PortletException, IOException {
        PortletRequestDispatcher dispatcher;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing mime result", new String[0]);
        }
        PortletContext ctx = PortletActionContext.getPortletContext();
        PortletRequest req = PortletActionContext.getRequest();
        PortletResponse res = PortletActionContext.getResponse();
        if (StringUtils.isNotEmpty((String)this.title) && res instanceof RenderResponse) {
            ((RenderResponse)res).setTitle(this.title);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Location: " + finalLocation, new String[0]);
        }
        if (this.useDispatcherServlet) {
            req.setAttribute("struts.portlet.dispatchTo", (Object)finalLocation);
            dispatcher = ctx.getNamedDispatcher(this.dispatcherServletName);
            if (dispatcher == null) {
                throw new PortletException("Could not locate dispatcher servlet \"" + this.dispatcherServletName + "\". Please configure it in your web.xml file");
            }
        } else {
            dispatcher = ctx.getRequestDispatcher(finalLocation);
            if (dispatcher == null) {
                throw new PortletException("Could not locate dispatcher for '" + finalLocation + "'");
            }
        }
        this.resultHelper.include(dispatcher, this.contentType, req, res);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setPortletMode(String portletMode) {
        if (portletMode != null) {
            this.portletMode = new PortletMode(portletMode);
        }
    }

    @Inject(value="struts.portlet.useDispatcherServlet")
    public void setUseDispatcherServlet(String useDispatcherServlet) {
        this.useDispatcherServlet = "true".equalsIgnoreCase(useDispatcherServlet);
    }

    @Inject(value="struts.portlet.dispatcherServletName")
    public void setDispatcherServletName(String dispatcherServletName) {
        this.dispatcherServletName = dispatcherServletName;
    }
}

