/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.tiles;

import com.opensymphony.xwork2.ActionInvocation;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts2.portlet.PortletConstants;
import org.apache.struts2.portlet.context.PortletActionContext;
import org.apache.struts2.result.ServletDispatcherResult;
import org.apache.tiles.api.TilesContainer;
import org.apache.tiles.api.TilesException;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.portlet.RenderPortletRequest;

public class PortletTilesResult
extends ServletDispatcherResult {
    public static final String TILES_ACTION_NAME = "tilesDirect";

    public PortletTilesResult() {
    }

    public PortletTilesResult(String location) {
        super(location);
    }

    public void doExecute(String location, ActionInvocation invocation) throws Exception {
        if (PortletActionContext.getPhase().isAction() || PortletActionContext.getPhase().isEvent()) {
            this.executeActionResult(location, invocation);
        } else {
            this.executeRenderResult(location);
        }
    }

    protected void executeRenderResult(String location) throws TilesException {
        this.setLocation(location);
        PortletContext portletContext = PortletActionContext.getPortletContext();
        RenderRequest request = PortletActionContext.getRenderRequest();
        RenderResponse response = PortletActionContext.getRenderResponse();
        TilesContainer container = this.getCurrentContainer((PortletRequest)request, portletContext);
        ApplicationContext applicationContext = container.getApplicationContext();
        RenderPortletRequest currentRequest = new RenderPortletRequest(applicationContext, portletContext, request, response);
        container.render(location, (Request)currentRequest);
    }

    protected void executeActionResult(String location, ActionInvocation invocation) {
        ActionResponse res = PortletActionContext.getActionResponse();
        res.setRenderParameter(PortletConstants.ACTION_PARAM, TILES_ACTION_NAME);
        Map sessionMap = invocation.getInvocationContext().getSession();
        sessionMap.put(PortletConstants.RENDER_DIRECT_LOCATION, location);
        res.setRenderParameter(PortletConstants.MODE_PARAM, PortletActionContext.getRequest().getPortletMode().toString());
    }

    protected TilesContainer getCurrentContainer(PortletRequest request, PortletContext context) {
        TilesContainer container = (TilesContainer)request.getAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY");
        if (container == null) {
            container = this.getContainer(context);
            request.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY", (Object)container);
        }
        return container;
    }

    protected TilesContainer getContainer(PortletContext context) {
        return this.getContainer(context, "org.apache.tiles.CONTAINER");
    }

    protected TilesContainer getContainer(PortletContext context, String key) {
        if (key == null) {
            key = "org.apache.tiles.CONTAINER";
        }
        return (TilesContainer)context.getAttribute(key);
    }
}

