/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.portlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import org.apache.tiles.request.AbstractClientRequest;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.attribute.Addable;
import org.apache.tiles.request.attribute.AttributeExtractor;
import org.apache.tiles.request.attribute.EnumeratedValuesExtractor;
import org.apache.tiles.request.attribute.HasKeys;
import org.apache.tiles.request.collection.HeaderValuesMap;
import org.apache.tiles.request.collection.ReadOnlyEnumerationMap;
import org.apache.tiles.request.collection.ScopeMap;
import org.apache.tiles.request.portlet.delegate.RequestDelegate;
import org.apache.tiles.request.portlet.delegate.ResponseDelegate;
import org.apache.tiles.request.portlet.extractor.HeaderExtractor;
import org.apache.tiles.request.portlet.extractor.RequestScopeExtractor;
import org.apache.tiles.request.portlet.extractor.SessionScopeExtractor;

public class PortletRequest
extends AbstractClientRequest {
    private static final List<String> SCOPES = Collections.unmodifiableList(Arrays.asList("request", "portletSession", "session", "application"));
    private Map<String, String> header = null;
    private Addable<String> responseHeaders = null;
    private Map<String, String[]> headerValues = null;
    protected PortletContext context;
    protected javax.portlet.PortletRequest request;
    protected RequestDelegate requestDelegate;
    private Map<String, Object> requestScope = null;
    protected PortletResponse response;
    protected ResponseDelegate responseDelegate;
    private Map<String, Object> sessionScope = null;
    private Map<String, Object> portletSessionScope = null;

    public PortletRequest(ApplicationContext applicationContext, PortletContext context, javax.portlet.PortletRequest request, PortletResponse response, RequestDelegate requestDelegate, ResponseDelegate responseDelegate) {
        super(applicationContext);
        this.context = context;
        this.request = request;
        this.response = response;
        this.requestDelegate = requestDelegate;
        this.responseDelegate = responseDelegate;
    }

    public javax.portlet.PortletRequest getRequest() {
        return this.request;
    }

    public PortletContext getPortletContext() {
        return this.context;
    }

    public Map<String, String> getHeader() {
        if (this.header == null && this.request != null) {
            this.header = new ReadOnlyEnumerationMap((HasKeys)new HeaderExtractor(this.request, null));
        }
        return this.header;
    }

    public Addable<String> getResponseHeaders() {
        if (this.responseHeaders == null && this.request != null) {
            this.responseHeaders = new HeaderExtractor(null, this.response);
        }
        return this.responseHeaders;
    }

    public Map<String, String[]> getHeaderValues() {
        if (this.headerValues == null && this.request != null) {
            this.headerValues = new HeaderValuesMap((EnumeratedValuesExtractor)new HeaderExtractor(this.request, this.response));
        }
        return this.headerValues;
    }

    public Map<String, Object> getRequestScope() {
        if (this.requestScope == null && this.request != null) {
            this.requestScope = new ScopeMap((AttributeExtractor)new RequestScopeExtractor(this.request));
        }
        return this.requestScope;
    }

    public Map<String, Object> getSessionScope() {
        if (this.sessionScope == null && this.request != null) {
            this.sessionScope = new ScopeMap((AttributeExtractor)new SessionScopeExtractor(this.request, 1));
        }
        return this.sessionScope;
    }

    public Map<String, Object> getPortletSessionScope() {
        if (this.portletSessionScope == null && this.request != null) {
            this.portletSessionScope = new ScopeMap((AttributeExtractor)new SessionScopeExtractor(this.request, 1));
        }
        return this.portletSessionScope;
    }

    public List<String> getAvailableScopes() {
        return SCOPES;
    }

    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public Map<String, String> getParam() {
        return this.requestDelegate.getParam();
    }

    public Map<String, String[]> getParamValues() {
        return this.requestDelegate.getParamValues();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.responseDelegate.getOutputStream();
    }

    public PrintWriter getPrintWriter() throws IOException {
        return this.responseDelegate.getPrintWriter();
    }

    public Writer getWriter() throws IOException {
        return this.responseDelegate.getWriter();
    }

    public boolean isResponseCommitted() {
        return this.responseDelegate.isResponseCommitted();
    }

    public void setContentType(String contentType) {
        this.responseDelegate.setContentType(contentType);
    }

    public void doForward(String path) throws IOException {
        if (this.responseDelegate.isResponseCommitted()) {
            this.doInclude(path);
            return;
        }
        try {
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(path);
            if (rd == null) {
                throw new IOException("No portlet request dispatcher returned for path '" + path + "'");
            }
            rd.forward(this.request, this.response);
        }
        catch (PortletException e) {
            throw new IOException("PortletException while including path '" + path + "'.", e);
        }
    }

    public void doInclude(String path) throws IOException {
        try {
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(path);
            if (rd == null) {
                throw new IOException("No portlet request dispatcher returned for path '" + path + "'");
            }
            rd.include(this.request, this.response);
        }
        catch (PortletException e) {
            throw new IOException("PortletException while including path '" + path + "'.", e);
        }
    }

    public Map<String, Object> getContext(String scope) {
        if ("request".equals(scope)) {
            return this.getRequestScope();
        }
        if ("session".equals(scope)) {
            return this.getSessionScope();
        }
        if ("portletSession".equals(scope)) {
            return this.getPortletSessionScope();
        }
        if ("application".equals(scope)) {
            return this.getApplicationScope();
        }
        throw new IllegalArgumentException(scope + " does not exist. Call getAvailableScopes() first to check.");
    }
}

