/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest.handler;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.ArrayTypePermission;
import com.thoughtworks.xstream.security.ExplicitTypePermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.struts2.rest.handler.AbstractContentTypeHandler;
import org.apache.struts2.rest.handler.AllowedClassNames;
import org.apache.struts2.rest.handler.AllowedClasses;
import org.apache.struts2.rest.handler.XStreamPermissionProvider;

public class XStreamHandler
extends AbstractContentTypeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(XStreamHandler.class);

    @Override
    public String fromObject(ActionInvocation invocation, Object obj, String resultCode, Writer out) throws IOException {
        if (obj != null) {
            XStream xstream = this.createXStream(invocation);
            xstream.toXML(obj, out);
        }
        return null;
    }

    @Override
    public void toObject(ActionInvocation invocation, Reader in, Object target) {
        XStream xstream = this.createXStream(invocation);
        xstream.fromXML(in, target);
    }

    @Deprecated
    protected XStream createXStream() {
        LOG.warn("You are using a deprecated API!", new String[0]);
        return new XStream();
    }

    protected XStream createXStream(ActionInvocation invocation) {
        XStream stream = new XStream();
        LOG.debug("Clears existing permissions", new String[0]);
        stream.addPermission(NoTypePermission.NONE);
        LOG.debug("Adds per action permissions", new String[0]);
        this.addPerActionPermission(invocation, stream);
        LOG.debug("Adds default permissions", new String[0]);
        this.addDefaultPermissions(invocation, stream);
        return stream;
    }

    private void addPerActionPermission(ActionInvocation invocation, XStream stream) {
        Object action = invocation.getAction();
        if (action instanceof AllowedClasses) {
            Set<Class<?>> allowedClasses = ((AllowedClasses)action).allowedClasses();
            stream.addPermission((TypePermission)new ExplicitTypePermission(allowedClasses.toArray(new Class[allowedClasses.size()])));
        }
        if (action instanceof AllowedClassNames) {
            Set<String> allowedClassNames = ((AllowedClassNames)action).allowedClassNames();
            stream.addPermission((TypePermission)new ExplicitTypePermission(allowedClassNames.toArray(new String[allowedClassNames.size()])));
        }
        if (action instanceof XStreamPermissionProvider) {
            Collection<TypePermission> permissions = ((XStreamPermissionProvider)action).getTypePermissions();
            for (TypePermission permission : permissions) {
                stream.addPermission(permission);
            }
        }
    }

    protected void addDefaultPermissions(ActionInvocation invocation, XStream stream) {
        stream.addPermission((TypePermission)new ExplicitTypePermission(new Class[]{invocation.getAction().getClass()}));
        if (invocation.getAction() instanceof ModelDriven) {
            stream.addPermission((TypePermission)new ExplicitTypePermission(new Class[]{((ModelDriven)invocation.getAction()).getModel().getClass()}));
        }
        stream.addPermission(NullPermission.NULL);
        stream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        stream.addPermission(ArrayTypePermission.ARRAYS);
        stream.addPermission(CollectionTypePermission.COLLECTIONS);
        stream.addPermission((TypePermission)new ExplicitTypePermission(new Class[]{Date.class}));
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public String getExtension() {
        return "xml";
    }

    private static class CollectionTypePermission
    implements TypePermission {
        private static final TypePermission COLLECTIONS = new CollectionTypePermission();

        private CollectionTypePermission() {
        }

        public boolean allows(Class type) {
            return type != null && type.isInterface() && (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type));
        }
    }
}

