/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import com.opensymphony.xwork2.util.TextParseUtil;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.servlet.ServletContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.apache.struts2.tiles.I18NAttributeEvaluator;
import org.apache.struts2.tiles.StrutsAttributeEvaluator;
import org.apache.struts2.tiles.StrutsFreeMarkerAttributeRenderer;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.context.ChainedTilesRequestContextFactory;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.pattern.DefinitionPatternMatcherFactory;
import org.apache.tiles.definition.pattern.PatternDefinitionResolver;
import org.apache.tiles.definition.pattern.PrefixedPatternDefinitionResolver;
import org.apache.tiles.definition.pattern.regexp.RegexpDefinitionPatternMatcherFactory;
import org.apache.tiles.definition.pattern.wildcard.WildcardDefinitionPatternMatcherFactory;
import org.apache.tiles.el.ELAttributeEvaluator;
import org.apache.tiles.el.JspExpressionFactoryFactory;
import org.apache.tiles.el.TilesContextBeanELResolver;
import org.apache.tiles.el.TilesContextELResolver;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.evaluator.BasicAttributeEvaluatorFactory;
import org.apache.tiles.evaluator.impl.DirectAttributeEvaluator;
import org.apache.tiles.factory.BasicTilesContainerFactory;
import org.apache.tiles.factory.TilesContainerFactoryException;
import org.apache.tiles.freemarker.context.FreeMarkerTilesRequestContextFactory;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.impl.mgmt.CachingTilesContainer;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.ognl.ApplicationScopeNestedObjectExtractor;
import org.apache.tiles.ognl.DelegatePropertyAccessor;
import org.apache.tiles.ognl.NestedObjectDelegatePropertyAccessor;
import org.apache.tiles.ognl.NestedObjectExtractor;
import org.apache.tiles.ognl.OGNLAttributeEvaluator;
import org.apache.tiles.ognl.PropertyAccessorDelegateFactory;
import org.apache.tiles.ognl.RequestScopeNestedObjectExtractor;
import org.apache.tiles.ognl.SessionScopeNestedObjectExtractor;
import org.apache.tiles.ognl.TilesApplicationContextNestedObjectExtractor;
import org.apache.tiles.ognl.TilesContextPropertyAccessorDelegateFactory;
import org.apache.tiles.renderer.AttributeRenderer;
import org.apache.tiles.renderer.TypeDetectingAttributeRenderer;
import org.apache.tiles.renderer.impl.BasicRendererFactory;
import org.apache.tiles.renderer.impl.ChainedDelegateAttributeRenderer;
import org.apache.tiles.servlet.context.ServletUtil;
import org.apache.tiles.util.URLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsTilesContainerFactory
extends BasicTilesContainerFactory {
    public static final String FREEMARKER_RENDERER_NAME = "freemarker";
    public static final String PATTERN_WILDCARD = "WILDCARD";
    public static final String PATTERN_REGEXP = "REGEXP";
    public static final String TILES_DEFAULT_PATTERN = "tiles*.xml";
    public static final String OGNL = "OGNL";
    public static final String EL = "EL";
    public static final String S2 = "S2";
    public static final String I18N = "I18N";

    protected BasicTilesContainer instantiateContainer(TilesApplicationContext applicationContext) {
        CachingTilesContainer tilesContainer = new CachingTilesContainer();
        ServletContext servletContext = (ServletContext)applicationContext.getContext();
        ServletUtil.setContainer((ServletContext)servletContext, (TilesContainer)tilesContainer);
        return tilesContainer;
    }

    protected List<TilesRequestContextFactory> getTilesRequestContextFactoriesToBeChained(ChainedTilesRequestContextFactory parent) {
        List factories = super.getTilesRequestContextFactoriesToBeChained(parent);
        this.registerRequestContextFactory(FreeMarkerTilesRequestContextFactory.class.getName(), factories, (TilesRequestContextFactory)parent);
        return factories;
    }

    protected void registerAttributeRenderers(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        super.registerAttributeRenderers(rendererFactory, applicationContext, contextFactory, container, attributeEvaluatorFactory);
        StrutsFreeMarkerAttributeRenderer freemarkerRenderer = new StrutsFreeMarkerAttributeRenderer();
        freemarkerRenderer.setApplicationContext(applicationContext);
        freemarkerRenderer.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        freemarkerRenderer.setRequestContextFactory(contextFactory);
        rendererFactory.registerRenderer(FREEMARKER_RENDERER_NAME, (AttributeRenderer)freemarkerRenderer);
    }

    protected AttributeRenderer createDefaultAttributeRenderer(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        ChainedDelegateAttributeRenderer retValue = new ChainedDelegateAttributeRenderer();
        retValue.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer("definition"));
        retValue.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer(FREEMARKER_RENDERER_NAME));
        retValue.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer("template"));
        retValue.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer("string"));
        retValue.setApplicationContext(applicationContext);
        retValue.setRequestContextFactory(contextFactory);
        retValue.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        return retValue;
    }

    protected AttributeEvaluatorFactory createAttributeEvaluatorFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        BasicAttributeEvaluatorFactory attributeEvaluatorFactory = new BasicAttributeEvaluatorFactory((AttributeEvaluator)new DirectAttributeEvaluator());
        attributeEvaluatorFactory.registerAttributeEvaluator(S2, (AttributeEvaluator)this.createStrutsEvaluator());
        attributeEvaluatorFactory.registerAttributeEvaluator(I18N, (AttributeEvaluator)this.createI18NEvaluator());
        attributeEvaluatorFactory.registerAttributeEvaluator(OGNL, (AttributeEvaluator)this.createOGNLEvaluator());
        ELAttributeEvaluator elEvaluator = this.createELEvaluator(applicationContext);
        if (elEvaluator != null) {
            attributeEvaluatorFactory.registerAttributeEvaluator(EL, (AttributeEvaluator)elEvaluator);
        }
        return attributeEvaluatorFactory;
    }

    protected <T> PatternDefinitionResolver<T> createPatternDefinitionResolver(Class<T> customizationKeyClass) {
        WildcardDefinitionPatternMatcherFactory wildcardFactory = new WildcardDefinitionPatternMatcherFactory();
        RegexpDefinitionPatternMatcherFactory regexpFactory = new RegexpDefinitionPatternMatcherFactory();
        PrefixedPatternDefinitionResolver resolver = new PrefixedPatternDefinitionResolver();
        resolver.registerDefinitionPatternMatcherFactory(PATTERN_WILDCARD, (DefinitionPatternMatcherFactory)wildcardFactory);
        resolver.registerDefinitionPatternMatcherFactory(PATTERN_REGEXP, (DefinitionPatternMatcherFactory)regexpFactory);
        return resolver;
    }

    protected List<URL> getSourceURLs(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        try {
            HashSet finalSet = new HashSet();
            Set<String> definitions = this.getTilesDefinitions(applicationContext.getInitParams());
            for (String definition : definitions) {
                finalSet.addAll(applicationContext.getResources(definition));
            }
            return URLUtil.getBaseTilesDefinitionURLs(finalSet);
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("Cannot load definition URLs", (Exception)e);
        }
    }

    protected Set<String> getTilesDefinitions(Map<String, String> params) {
        if (params.containsKey("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG")) {
            return TextParseUtil.commaDelimitedStringToSet((String)params.get("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG"));
        }
        if (params.containsKey("org.apache.tiles.impl.BasicTilesContainer.DEFINITIONS_CONFIG")) {
            return TextParseUtil.commaDelimitedStringToSet((String)params.get("org.apache.tiles.impl.BasicTilesContainer.DEFINITIONS_CONFIG"));
        }
        return TextParseUtil.commaDelimitedStringToSet((String)TILES_DEFAULT_PATTERN);
    }

    protected ELAttributeEvaluator createELEvaluator(TilesApplicationContext applicationContext) {
        ELAttributeEvaluator evaluator = new ELAttributeEvaluator();
        evaluator.setApplicationContext(applicationContext);
        JspExpressionFactoryFactory efFactory = new JspExpressionFactoryFactory();
        efFactory.setApplicationContext(applicationContext);
        evaluator.setExpressionFactory(efFactory.getExpressionFactory());
        CompositeELResolver elResolver = new CompositeELResolver(){
            {
                this.add((ELResolver)new TilesContextELResolver());
                this.add((ELResolver)new TilesContextBeanELResolver());
                this.add((ELResolver)new ArrayELResolver(false));
                this.add((ELResolver)new ListELResolver(false));
                this.add((ELResolver)new MapELResolver(false));
                this.add((ELResolver)new ResourceBundleELResolver());
                this.add((ELResolver)new BeanELResolver(false));
            }
        };
        evaluator.setResolver((ELResolver)elResolver);
        return evaluator;
    }

    protected StrutsAttributeEvaluator createStrutsEvaluator() {
        return new StrutsAttributeEvaluator();
    }

    protected I18NAttributeEvaluator createI18NEvaluator() {
        return new I18NAttributeEvaluator();
    }

    protected OGNLAttributeEvaluator createOGNLEvaluator() {
        try {
            PropertyAccessor objectPropertyAccessor = OgnlRuntime.getPropertyAccessor(Object.class);
            PropertyAccessor mapPropertyAccessor = OgnlRuntime.getPropertyAccessor(Map.class);
            NestedObjectDelegatePropertyAccessor applicationContextPropertyAccessor = new NestedObjectDelegatePropertyAccessor((NestedObjectExtractor)new TilesApplicationContextNestedObjectExtractor(), objectPropertyAccessor);
            NestedObjectDelegatePropertyAccessor requestScopePropertyAccessor = new NestedObjectDelegatePropertyAccessor((NestedObjectExtractor)new RequestScopeNestedObjectExtractor(), mapPropertyAccessor);
            NestedObjectDelegatePropertyAccessor sessionScopePropertyAccessor = new NestedObjectDelegatePropertyAccessor((NestedObjectExtractor)new SessionScopeNestedObjectExtractor(), mapPropertyAccessor);
            NestedObjectDelegatePropertyAccessor applicationScopePropertyAccessor = new NestedObjectDelegatePropertyAccessor((NestedObjectExtractor)new ApplicationScopeNestedObjectExtractor(), mapPropertyAccessor);
            TilesContextPropertyAccessorDelegateFactory factory = new TilesContextPropertyAccessorDelegateFactory(objectPropertyAccessor, (PropertyAccessor)applicationContextPropertyAccessor, (PropertyAccessor)requestScopePropertyAccessor, (PropertyAccessor)sessionScopePropertyAccessor, (PropertyAccessor)applicationScopePropertyAccessor);
            DelegatePropertyAccessor tilesRequestAccessor = new DelegatePropertyAccessor((PropertyAccessorDelegateFactory)factory);
            OgnlRuntime.setPropertyAccessor(TilesRequestContext.class, (PropertyAccessor)tilesRequestAccessor);
            return new OGNLAttributeEvaluator();
        }
        catch (OgnlException e) {
            throw new TilesContainerFactoryException("Cannot initialize OGNL evaluator", (Exception)((Object)e));
        }
    }
}

