/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.tiles.api.TilesContainer;
import org.apache.tiles.core.definition.DefinitionsFactory;
import org.apache.tiles.core.definition.DefinitionsReader;
import org.apache.tiles.core.definition.UnresolvingLocaleDefinitionsFactory;
import org.apache.tiles.core.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.core.definition.dao.DefinitionDAO;
import org.apache.tiles.core.definition.dao.ResolvingLocaleUrlDefinitionDAO;
import org.apache.tiles.core.definition.digester.DigesterDefinitionsReader;
import org.apache.tiles.core.definition.pattern.BasicPatternDefinitionResolver;
import org.apache.tiles.core.definition.pattern.PatternDefinitionResolver;
import org.apache.tiles.core.definition.pattern.PatternDefinitionResolverAware;
import org.apache.tiles.core.definition.pattern.wildcard.WildcardDefinitionPatternMatcherFactory;
import org.apache.tiles.core.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.core.evaluator.BasicAttributeEvaluatorFactory;
import org.apache.tiles.core.evaluator.impl.DirectAttributeEvaluator;
import org.apache.tiles.core.factory.AbstractTilesContainerFactory;
import org.apache.tiles.core.impl.BasicTilesContainer;
import org.apache.tiles.core.locale.LocaleResolver;
import org.apache.tiles.core.locale.impl.DefaultLocaleResolver;
import org.apache.tiles.core.prepare.factory.BasicPreparerFactory;
import org.apache.tiles.core.prepare.factory.PreparerFactory;
import org.apache.tiles.core.renderer.DefinitionRenderer;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.render.BasicRendererFactory;
import org.apache.tiles.request.render.ChainedDelegateRenderer;
import org.apache.tiles.request.render.DispatchRenderer;
import org.apache.tiles.request.render.Renderer;
import org.apache.tiles.request.render.RendererFactory;
import org.apache.tiles.request.render.StringRenderer;

public class BasicTilesContainerFactory
extends AbstractTilesContainerFactory {
    protected static final String STRING_RENDERER_NAME = "string";
    protected static final String TEMPLATE_RENDERER_NAME = "template";
    protected static final String DEFINITION_RENDERER_NAME = "definition";

    @Override
    public TilesContainer createContainer(ApplicationContext applicationContext) {
        BasicTilesContainer container = this.instantiateContainer(applicationContext);
        container.setApplicationContext(applicationContext);
        LocaleResolver resolver = this.createLocaleResolver(applicationContext);
        container.setDefinitionsFactory(this.createDefinitionsFactory(applicationContext, resolver));
        AttributeEvaluatorFactory attributeEvaluatorFactory = this.createAttributeEvaluatorFactory(applicationContext, resolver);
        container.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        container.setPreparerFactory(this.createPreparerFactory(applicationContext));
        TilesContainer injectedContainer = this.createDecoratedContainer(container, applicationContext);
        container.setRendererFactory(this.createRendererFactory(applicationContext, injectedContainer, attributeEvaluatorFactory));
        return injectedContainer;
    }

    protected BasicTilesContainer instantiateContainer(ApplicationContext context) {
        return new BasicTilesContainer();
    }

    protected TilesContainer createDecoratedContainer(TilesContainer originalContainer, ApplicationContext context) {
        return originalContainer;
    }

    protected DefinitionsFactory createDefinitionsFactory(ApplicationContext applicationContext, LocaleResolver resolver) {
        UnresolvingLocaleDefinitionsFactory factory = this.instantiateDefinitionsFactory(applicationContext, resolver);
        factory.setLocaleResolver(resolver);
        factory.setDefinitionDAO(this.createLocaleDefinitionDao(applicationContext, resolver));
        return factory;
    }

    protected UnresolvingLocaleDefinitionsFactory instantiateDefinitionsFactory(ApplicationContext applicationContext, LocaleResolver resolver) {
        return new UnresolvingLocaleDefinitionsFactory();
    }

    protected BaseLocaleUrlDefinitionDAO instantiateLocaleDefinitionDao(ApplicationContext applicationContext, LocaleResolver resolver) {
        return new ResolvingLocaleUrlDefinitionDAO(applicationContext);
    }

    protected DefinitionDAO<Locale> createLocaleDefinitionDao(ApplicationContext applicationContext, LocaleResolver resolver) {
        BaseLocaleUrlDefinitionDAO definitionDao = this.instantiateLocaleDefinitionDao(applicationContext, resolver);
        definitionDao.setReader(this.createDefinitionsReader(applicationContext));
        definitionDao.setSources(this.getSources(applicationContext));
        if (definitionDao instanceof PatternDefinitionResolverAware) {
            ((PatternDefinitionResolverAware)((Object)definitionDao)).setPatternDefinitionResolver(this.createPatternDefinitionResolver(Locale.class));
        }
        return definitionDao;
    }

    protected LocaleResolver createLocaleResolver(ApplicationContext applicationContext) {
        return new DefaultLocaleResolver();
    }

    protected DefinitionsReader createDefinitionsReader(ApplicationContext applicationContext) {
        return new DigesterDefinitionsReader();
    }

    protected List<ApplicationResource> getSources(ApplicationContext applicationContext) {
        ArrayList<ApplicationResource> retValue = new ArrayList<ApplicationResource>(1);
        retValue.add(applicationContext.getResource("/WEB-INF/tiles.xml"));
        return retValue;
    }

    protected AttributeEvaluatorFactory createAttributeEvaluatorFactory(ApplicationContext applicationContext, LocaleResolver resolver) {
        return new BasicAttributeEvaluatorFactory(new DirectAttributeEvaluator());
    }

    protected PreparerFactory createPreparerFactory(ApplicationContext applicationContext) {
        return new BasicPreparerFactory();
    }

    protected RendererFactory createRendererFactory(ApplicationContext applicationContext, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        BasicRendererFactory retValue = new BasicRendererFactory();
        this.registerAttributeRenderers(retValue, applicationContext, container, attributeEvaluatorFactory);
        retValue.setDefaultRenderer(this.createDefaultAttributeRenderer(retValue, applicationContext, container, attributeEvaluatorFactory));
        return retValue;
    }

    protected Renderer createDefaultAttributeRenderer(BasicRendererFactory rendererFactory, ApplicationContext applicationContext, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        ChainedDelegateRenderer retValue = new ChainedDelegateRenderer();
        retValue.addAttributeRenderer(rendererFactory.getRenderer(DEFINITION_RENDERER_NAME));
        retValue.addAttributeRenderer(rendererFactory.getRenderer(TEMPLATE_RENDERER_NAME));
        retValue.addAttributeRenderer(rendererFactory.getRenderer(STRING_RENDERER_NAME));
        return retValue;
    }

    protected <T> PatternDefinitionResolver<T> createPatternDefinitionResolver(Class<T> customizationKeyClass) {
        WildcardDefinitionPatternMatcherFactory definitionPatternMatcherFactory = new WildcardDefinitionPatternMatcherFactory();
        return new BasicPatternDefinitionResolver(definitionPatternMatcherFactory, definitionPatternMatcherFactory);
    }

    protected void registerAttributeRenderers(BasicRendererFactory rendererFactory, ApplicationContext applicationContext, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        rendererFactory.registerRenderer(STRING_RENDERER_NAME, this.createStringAttributeRenderer(rendererFactory, applicationContext, container, attributeEvaluatorFactory));
        rendererFactory.registerRenderer(TEMPLATE_RENDERER_NAME, this.createTemplateAttributeRenderer(rendererFactory, applicationContext, container, attributeEvaluatorFactory));
        rendererFactory.registerRenderer(DEFINITION_RENDERER_NAME, this.createDefinitionAttributeRenderer(rendererFactory, applicationContext, container, attributeEvaluatorFactory));
    }

    protected Renderer createStringAttributeRenderer(BasicRendererFactory rendererFactory, ApplicationContext applicationContext, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        return new StringRenderer();
    }

    protected Renderer createTemplateAttributeRenderer(BasicRendererFactory rendererFactory, ApplicationContext applicationContext, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        return new DispatchRenderer();
    }

    protected Renderer createDefinitionAttributeRenderer(BasicRendererFactory rendererFactory, ApplicationContext applicationContext, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        return new DefinitionRenderer(container);
    }
}

