/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.cluster;

import io.atomix.primitive.PrimitiveState;
import org.apache.submarine.commons.cluster.ClusterManager;
import org.apache.submarine.commons.cluster.ClusterMonitor;
import org.apache.submarine.commons.cluster.meta.ClusterMetaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterClient
extends ClusterManager {
    private static Logger LOG = LoggerFactory.getLogger(ClusterClient.class);
    private static ClusterClient instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterClient getInstance() {
        Class<ClusterClient> clazz = ClusterClient.class;
        synchronized (ClusterClient.class) {
            if (instance == null) {
                instance = new ClusterClient();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ClusterClient() {
    }

    @Override
    public boolean raftInitialized() {
        return null != this.raftClient && null != this.raftSessionClient && this.raftSessionClient.getState() == PrimitiveState.CONNECTED;
    }

    @Override
    public boolean isClusterLeader() {
        return false;
    }

    public void start(String metaKey) {
        LOG.info("ClusterClient::start({})", (Object)metaKey);
        if (!this.sconf.isClusterMode()) {
            return;
        }
        super.start();
        this.clusterMonitor = new ClusterMonitor(this);
        this.clusterMonitor.start(ClusterMetaType.INTP_PROCESS_META, metaKey);
    }

    @Override
    public void shutdown() {
        if (!this.sconf.isClusterMode()) {
            return;
        }
        if (null != this.clusterMonitor) {
            this.clusterMonitor.shutdown();
        }
        super.shutdown();
    }
}

