/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.cluster;

import com.google.common.collect.Maps;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.service.Commit;
import io.atomix.primitive.service.ServiceExecutor;
import io.atomix.utils.serializer.Serializer;
import java.util.Map;
import org.apache.submarine.commons.cluster.ClusterManager;
import org.apache.submarine.commons.cluster.ClusterPrimitiveType;
import org.apache.submarine.commons.cluster.meta.ClusterMeta;
import org.apache.submarine.commons.cluster.meta.ClusterMetaEntity;
import org.apache.submarine.commons.cluster.meta.ClusterMetaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStateMachine
extends AbstractPrimitiveService {
    private static Logger LOG = LoggerFactory.getLogger(ClusterStateMachine.class);
    private ClusterMeta clusterMeta = new ClusterMeta();
    public static final OperationId PUT = OperationId.command((String)"put");
    public static final OperationId GET = OperationId.query((String)"get");
    public static final OperationId REMOVE = OperationId.command((String)"remove");
    public static final OperationId INDEX = OperationId.command((String)"index");

    public ClusterStateMachine() {
        super((PrimitiveType)ClusterPrimitiveType.INSTANCE);
    }

    public Serializer serializer() {
        return ClusterManager.clientSerializer;
    }

    protected void configure(ServiceExecutor executor) {
        executor.register(PUT, this::put);
        executor.register(GET, this::get);
        executor.register(REMOVE, this::remove);
        executor.register(INDEX, this::index);
    }

    protected long put(Commit<ClusterMetaEntity> commit) {
        this.clusterMeta.put(((ClusterMetaEntity)commit.value()).getMetaType(), ((ClusterMetaEntity)commit.value()).getKey(), ((ClusterMetaEntity)commit.value()).getValues());
        return commit.index();
    }

    protected Map<String, Map<String, Object>> get(Commit<ClusterMetaEntity> commit) {
        return this.clusterMeta.get(((ClusterMetaEntity)commit.value()).getMetaType(), ((ClusterMetaEntity)commit.value()).getKey());
    }

    protected long remove(Commit<ClusterMetaEntity> commit) {
        this.clusterMeta.remove(((ClusterMetaEntity)commit.value()).getMetaType(), ((ClusterMetaEntity)commit.value()).getKey());
        return commit.index();
    }

    protected long index(Commit<Void> commit) {
        return commit.index();
    }

    public void backup(BackupOutput writer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ClusterStateMachine.backup()");
        }
        Map<String, Map<String, Object>> mapServerMeta = this.clusterMeta.get(ClusterMetaType.SERVER_META, "");
        writer.writeInt(mapServerMeta.size());
        for (Map.Entry<String, Map<String, Object>> entry : mapServerMeta.entrySet()) {
            writer.writeString(entry.getKey());
            Map<String, Object> kvPairs = entry.getValue();
            writer.writeInt(kvPairs.size());
            for (Map.Entry<String, Object> entryValue : kvPairs.entrySet()) {
                writer.writeString(entryValue.getKey());
                writer.writeObject(entryValue.getValue());
            }
        }
        Map<String, Map<String, Object>> mapIntpProcMeta = this.clusterMeta.get(ClusterMetaType.INTP_PROCESS_META, "");
        writer.writeInt(mapIntpProcMeta.size());
        for (Map.Entry<String, Map<String, Object>> entry : mapIntpProcMeta.entrySet()) {
            writer.writeString(entry.getKey());
            Map<String, Object> kvPairs = entry.getValue();
            writer.writeInt(kvPairs.size());
            for (Map.Entry<String, Object> entryValue : kvPairs.entrySet()) {
                writer.writeString(entryValue.getKey());
                writer.writeObject(entryValue.getValue());
            }
        }
    }

    public void restore(BackupInput reader) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ClusterStateMachine.restore()");
        }
        this.clusterMeta = new ClusterMeta();
        int nServerMeta = reader.readInt();
        for (int i = 0; i < nServerMeta; ++i) {
            String clusterName = reader.readString();
            int nKVpairs = reader.readInt();
            int j = 0;
            while (j < nKVpairs) {
                String key = reader.readString();
                Object value = reader.readObject();
                this.clusterMeta.put(ClusterMetaType.SERVER_META, clusterName, Maps.immutableEntry((Object)key, (Object)value));
                ++i;
            }
        }
        int nIntpMeta = reader.readInt();
        for (int i = 0; i < nIntpMeta; ++i) {
            String intpName = reader.readString();
            int nKVpairs = reader.readInt();
            int j = 0;
            while (j < nKVpairs) {
                String key = reader.readString();
                Object value = reader.readObject();
                this.clusterMeta.put(ClusterMetaType.INTP_PROCESS_META, intpName, Maps.immutableEntry((Object)key, (Object)value));
                ++i;
            }
        }
    }
}

