/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.cluster.meta;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.submarine.commons.cluster.meta.ClusterMetaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMeta
implements Serializable {
    private static Logger LOG = LoggerFactory.getLogger(ClusterMeta.class);
    public static String NODE_NAME = "NODE_NAME";
    public static String SERVER_HOST = "SERVER_HOST";
    public static String SERVER_PORT = "SERVER_PORT";
    public static String SERVER_START_TIME = "SERVER_START_TIME";
    public static String INTP_PROCESS_NAME = "INTP_PROCESS_NAME";
    public static String INTP_TSERVER_HOST = "INTP_TSERVER_HOST";
    public static String INTP_TSERVER_PORT = "INTP_TSERVER_PORT";
    public static String INTP_START_TIME = "INTP_START_TIME";
    public static String CPU_CAPACITY = "CPU_CAPACITY";
    public static String CPU_USED = "CPU_USED";
    public static String MEMORY_CAPACITY = "MEMORY_CAPACITY";
    public static String MEMORY_USED = "MEMORY_USED";
    public static String LATEST_HEARTBEAT = "LATEST_HEARTBEAT";
    public static String STATUS = "STATUS";
    public static String ONLINE_STATUS = "ONLINE";
    public static String OFFLINE_STATUS = "OFFLINE";
    public static String INTP_PROCESS_COUNT = "INTP_PROCESS_COUNT";
    public static String INTP_PROCESS_LIST = "INTP_PROCESS_LIST";
    public static String PROPERTIES = "properties";
    private Map<String, Map<String, Object>> mapServerMeta = new HashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> mapInterpreterMeta = new HashMap<String, Map<String, Object>>();

    public void put(ClusterMetaType type, String key, Object value) {
        Map mapValue = (Map)value;
        switch (type) {
            case SERVER_META: {
                if (this.mapServerMeta.containsKey(key)) {
                    Map<String, Object> values = this.mapServerMeta.get(key);
                    values.putAll(mapValue);
                    break;
                }
                this.mapServerMeta.put(key, mapValue);
                break;
            }
            case INTP_PROCESS_META: {
                if (this.mapInterpreterMeta.containsKey(key)) {
                    Map<String, Object> values = this.mapInterpreterMeta.get(key);
                    values.putAll(mapValue);
                    break;
                }
                this.mapInterpreterMeta.put(key, mapValue);
            }
        }
    }

    public Map<String, Map<String, Object>> get(ClusterMetaType type, String key) {
        Map<String, Object> values = null;
        switch (type) {
            case SERVER_META: {
                if (null == key || StringUtils.isEmpty((String)key)) {
                    return this.mapServerMeta;
                }
                if (this.mapServerMeta.containsKey(key)) {
                    values = this.mapServerMeta.get(key);
                    break;
                }
                LOG.warn("can not find key : {}", (Object)key);
                break;
            }
            case INTP_PROCESS_META: {
                if (null == key || StringUtils.isEmpty((String)key)) {
                    return this.mapInterpreterMeta;
                }
                if (this.mapInterpreterMeta.containsKey(key)) {
                    values = this.mapInterpreterMeta.get(key);
                    break;
                }
                LOG.warn("can not find key : {}", (Object)key);
            }
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        result.put(key, values);
        return result;
    }

    public Map<String, Object> remove(ClusterMetaType type, String key) {
        switch (type) {
            case SERVER_META: {
                if (this.mapServerMeta.containsKey(key)) {
                    return this.mapServerMeta.remove(key);
                }
                LOG.warn("can not find key : {}", (Object)key);
                break;
            }
            case INTP_PROCESS_META: {
                if (this.mapInterpreterMeta.containsKey(key)) {
                    return this.mapInterpreterMeta.remove(key);
                }
                LOG.warn("can not find key : {}", (Object)key);
            }
        }
        return null;
    }
}

