/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.metastore;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.RawStoreProxy;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.submarine.commons.utils.SubmarineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmarineMetaStore {
    private static final Logger LOG = LoggerFactory.getLogger(SubmarineMetaStore.class);
    private RawStore rs = null;

    public SubmarineMetaStore(SubmarineConfiguration submarineConf) {
        LOG.info("JdbcDriverClassName = {}", (Object)submarineConf.getJdbcDriverClassName());
        LOG.info("MetastoreJdbcUrl = {}", (Object)submarineConf.getMetastoreJdbcUrl());
        LOG.info("MetastoreJdbcUserName = {}", (Object)submarineConf.getMetastoreJdbcUserName());
        LOG.info("MetastoreJdbcPassword = {}", (Object)submarineConf.getMetastoreJdbcPassword());
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.METASTORE_CONNECTION_DRIVER, submarineConf.getJdbcDriverClassName());
        conf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, submarineConf.getMetastoreJdbcUrl());
        conf.setVar(HiveConf.ConfVars.METASTORE_CONNECTION_USER_NAME, submarineConf.getMetastoreJdbcUserName());
        conf.setVar(HiveConf.ConfVars.METASTOREPWD, submarineConf.getMetastoreJdbcPassword());
        try {
            this.rs = RawStoreProxy.getProxy((HiveConf)conf, (Configuration)conf, (String)conf.getVar(HiveConf.ConfVars.METASTORE_RAW_STORE_IMPL), (int)1);
        }
        catch (MetaException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public int getDatabaseCount() throws MetaException {
        int databaseCount = this.rs.getDatabaseCount();
        return databaseCount;
    }

    public List<String> getAllDatabases() throws MetaException {
        List databases = this.rs.getAllDatabases();
        return databases;
    }

    public Database getDatabase(String databaseName) throws NoSuchObjectException {
        Database database = this.rs.getDatabase(databaseName);
        return database;
    }

    public int getTableCount() throws MetaException {
        int tableCount = this.rs.getTableCount();
        return tableCount;
    }

    public List<String> getAllTables(String databaseName) throws MetaException {
        List tables = this.rs.getAllTables(databaseName);
        return tables;
    }

    public Table getTable(String databaseName, String tableName) throws MetaException {
        Table table = this.rs.getTable(databaseName, tableName);
        return table;
    }

    public void createDatabase(Database db) throws InvalidObjectException, MetaException {
        this.rs.createDatabase(db);
    }

    public boolean alterDatabase(String dbName, Database db) throws NoSuchObjectException, MetaException {
        boolean result = this.rs.alterDatabase(dbName, db);
        return result;
    }

    public boolean dropDatabase(String dbName) throws NoSuchObjectException, MetaException {
        boolean result = this.rs.dropDatabase(dbName);
        return result;
    }

    public void createTable(Table table) throws InvalidObjectException, MetaException {
        this.rs.createTable(table);
    }

    public boolean dropTable(String dbName, String tableName) throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
        boolean result = this.rs.dropTable(dbName, tableName);
        return result;
    }

    public int getPartitionCount() throws MetaException {
        int partitionCount = this.rs.getPartitionCount();
        return partitionCount;
    }

    public Partition getPartition(String dbName, String tableName, List<String> partVals) throws NoSuchObjectException, MetaException {
        Partition partition = this.rs.getPartition(dbName, tableName, partVals);
        return partition;
    }

    public List<TableMeta> getTableMeta(String dbNames, String tableNames, List<String> tableTypes) throws MetaException {
        List tableMetas = this.rs.getTableMeta(dbNames, tableNames, tableTypes);
        return tableMetas;
    }

    public void createTableWithConstraints(Table tbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) throws InvalidObjectException, MetaException {
        this.rs.createTableWithConstraints(tbl, primaryKeys, foreignKeys);
    }

    public boolean addPartitions(String dbName, String tblName, List<Partition> parts) throws InvalidObjectException, MetaException {
        boolean result = this.rs.addPartitions(dbName, tblName, parts);
        return result;
    }

    public boolean dropPartition(String dbName, String tableName, List<String> partVals) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean result = this.rs.dropPartition(dbName, tableName, partVals);
        return result;
    }

    public void alterTable(String dbname, String tableName, Table newTable) throws InvalidObjectException, MetaException {
        this.rs.alterTable(dbname, tableName, newTable);
    }

    public void alterIndex(String dbname, String baseTblName, String indexName, Index newIndex) throws InvalidObjectException, MetaException {
        this.rs.alterIndex(dbname, baseTblName, indexName, newIndex);
    }

    public void alterPartition(String dbname, String tableName, List<String> partVals, Partition newPart) throws InvalidObjectException, MetaException {
        this.rs.alterPartition(dbname, tableName, partVals, newPart);
    }

    public void addPrimaryKeys(List<SQLPrimaryKey> pks) throws InvalidObjectException, MetaException {
        this.rs.addPrimaryKeys(pks);
    }

    public boolean addIndex(Index index) throws InvalidObjectException, MetaException {
        boolean result = this.rs.addIndex(index);
        return result;
    }

    public boolean dropIndex(String dbName, String origTableName, String indexName) throws MetaException {
        boolean result = this.rs.dropIndex(dbName, origTableName, indexName);
        return result;
    }

    public Index getIndex(String dbName, String origTableName, String indexName) throws MetaException {
        Index index = this.rs.getIndex(dbName, origTableName, indexName);
        return index;
    }
}

