/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.grpc.metrics;

import io.opencensus.contrib.grpc.metrics.RpcViewConstants;
import io.opencensus.stats.Stats;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewManager;
import org.apache.submarine.shaded.rpc.com.google.common.annotations.VisibleForTesting;
import org.apache.submarine.shaded.rpc.com.google.common.collect.ImmutableSet;

public final class RpcViews {
    @VisibleForTesting
    static final ImmutableSet<View> RPC_CUMULATIVE_VIEWS_SET = ImmutableSet.of(RpcViewConstants.RPC_CLIENT_ERROR_COUNT_VIEW, RpcViewConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_VIEW, RpcViewConstants.RPC_CLIENT_REQUEST_BYTES_VIEW, RpcViewConstants.RPC_CLIENT_RESPONSE_BYTES_VIEW, RpcViewConstants.RPC_CLIENT_REQUEST_COUNT_VIEW, RpcViewConstants.RPC_CLIENT_RESPONSE_COUNT_VIEW, new View[]{RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES_VIEW, RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES_VIEW, RpcViewConstants.RPC_CLIENT_SERVER_ELAPSED_TIME_VIEW, RpcViewConstants.RPC_CLIENT_STARTED_COUNT_CUMULATIVE_VIEW, RpcViewConstants.RPC_CLIENT_FINISHED_COUNT_CUMULATIVE_VIEW, RpcViewConstants.RPC_SERVER_ERROR_COUNT_VIEW, RpcViewConstants.RPC_SERVER_SERVER_LATENCY_VIEW, RpcViewConstants.RPC_SERVER_SERVER_ELAPSED_TIME_VIEW, RpcViewConstants.RPC_SERVER_REQUEST_BYTES_VIEW, RpcViewConstants.RPC_SERVER_RESPONSE_BYTES_VIEW, RpcViewConstants.RPC_SERVER_REQUEST_COUNT_VIEW, RpcViewConstants.RPC_SERVER_RESPONSE_COUNT_VIEW, RpcViewConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_VIEW, RpcViewConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_VIEW, RpcViewConstants.RPC_SERVER_STARTED_COUNT_CUMULATIVE_VIEW, RpcViewConstants.RPC_SERVER_FINISHED_COUNT_CUMULATIVE_VIEW});
    @VisibleForTesting
    static final ImmutableSet<View> GRPC_CLIENT_VIEWS_SET = ImmutableSet.of(RpcViewConstants.GRPC_CLIENT_ROUNDTRIP_LATENCY_VIEW, RpcViewConstants.GRPC_CLIENT_SENT_BYTES_PER_RPC_VIEW, RpcViewConstants.GRPC_CLIENT_RECEIVED_BYTES_PER_RPC_VIEW, RpcViewConstants.GRPC_CLIENT_SENT_MESSAGES_PER_RPC_VIEW, RpcViewConstants.GRPC_CLIENT_RECEIVED_MESSAGES_PER_RPC_VIEW, RpcViewConstants.GRPC_CLIENT_SERVER_LATENCY_VIEW, new View[]{RpcViewConstants.GRPC_CLIENT_COMPLETED_RPC_VIEW, RpcViewConstants.GRPC_CLIENT_STARTED_RPC_VIEW});
    @VisibleForTesting
    static final ImmutableSet<View> GRPC_SERVER_VIEWS_SET = ImmutableSet.of(RpcViewConstants.GRPC_SERVER_SERVER_LATENCY_VIEW, RpcViewConstants.GRPC_SERVER_SENT_BYTES_PER_RPC_VIEW, RpcViewConstants.GRPC_SERVER_RECEIVED_BYTES_PER_RPC_VIEW, RpcViewConstants.GRPC_SERVER_SENT_MESSAGES_PER_RPC_VIEW, RpcViewConstants.GRPC_SERVER_RECEIVED_MESSAGES_PER_RPC_VIEW, RpcViewConstants.GRPC_SERVER_COMPLETED_RPC_VIEW, new View[]{RpcViewConstants.GRPC_SERVER_STARTED_RPC_VIEW});
    @VisibleForTesting
    static final ImmutableSet<View> RPC_INTERVAL_VIEWS_SET = ImmutableSet.of(RpcViewConstants.RPC_CLIENT_ERROR_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_REQUEST_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_RESPONSE_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_REQUEST_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_RESPONSE_COUNT_MINUTE_VIEW, new View[]{RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_SERVER_ELAPSED_TIME_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_STARTED_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_FINISHED_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_ERROR_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_SERVER_LATENCY_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_SERVER_ELAPSED_TIME_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_REQUEST_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_RESPONSE_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_REQUEST_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_RESPONSE_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_STARTED_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_SERVER_FINISHED_COUNT_MINUTE_VIEW, RpcViewConstants.RPC_CLIENT_ERROR_COUNT_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_ROUNDTRIP_LATENCY_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_REQUEST_BYTES_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_RESPONSE_BYTES_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_REQUEST_COUNT_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_RESPONSE_COUNT_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_SERVER_ELAPSED_TIME_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_STARTED_COUNT_HOUR_VIEW, RpcViewConstants.RPC_CLIENT_FINISHED_COUNT_HOUR_VIEW, RpcViewConstants.RPC_SERVER_ERROR_COUNT_HOUR_VIEW, RpcViewConstants.RPC_SERVER_SERVER_LATENCY_HOUR_VIEW, RpcViewConstants.RPC_SERVER_SERVER_ELAPSED_TIME_HOUR_VIEW, RpcViewConstants.RPC_SERVER_REQUEST_BYTES_HOUR_VIEW, RpcViewConstants.RPC_SERVER_RESPONSE_BYTES_HOUR_VIEW, RpcViewConstants.RPC_SERVER_REQUEST_COUNT_HOUR_VIEW, RpcViewConstants.RPC_SERVER_RESPONSE_COUNT_HOUR_VIEW, RpcViewConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES_HOUR_VIEW, RpcViewConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES_HOUR_VIEW, RpcViewConstants.RPC_SERVER_STARTED_COUNT_HOUR_VIEW, RpcViewConstants.RPC_SERVER_FINISHED_COUNT_HOUR_VIEW});
    @VisibleForTesting
    static final ImmutableSet<View> GRPC_REAL_TIME_METRICS_VIEWS_SET = ImmutableSet.of(RpcViewConstants.GRPC_CLIENT_SENT_BYTES_PER_METHOD_VIEW, RpcViewConstants.GRPC_CLIENT_RECEIVED_BYTES_PER_METHOD_VIEW, RpcViewConstants.GRPC_CLIENT_SENT_MESSAGES_PER_METHOD_VIEW, RpcViewConstants.GRPC_CLIENT_RECEIVED_MESSAGES_PER_METHOD_VIEW, RpcViewConstants.GRPC_SERVER_SENT_BYTES_PER_METHOD_VIEW, RpcViewConstants.GRPC_SERVER_RECEIVED_BYTES_PER_METHOD_VIEW, new View[]{RpcViewConstants.GRPC_SERVER_SENT_MESSAGES_PER_METHOD_VIEW, RpcViewConstants.GRPC_SERVER_RECEIVED_MESSAGES_PER_METHOD_VIEW});
    @VisibleForTesting
    static final ImmutableSet<View> GRPC_CLIENT_BASIC_VIEWS_SET = ImmutableSet.of(RpcViewConstants.GRPC_CLIENT_ROUNDTRIP_LATENCY_VIEW, RpcViewConstants.GRPC_CLIENT_STARTED_RPC_VIEW);
    @VisibleForTesting
    static final ImmutableSet<View> GRPC_SERVER_BASIC_VIEWS_SET = ImmutableSet.of(RpcViewConstants.GRPC_SERVER_SERVER_LATENCY_VIEW, RpcViewConstants.GRPC_SERVER_STARTED_RPC_VIEW);

    public static void registerAllGrpcViews() {
        RpcViews.registerAllGrpcViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerAllGrpcViews(ViewManager viewManager) {
        RpcViews.registerClientGrpcViews(viewManager);
        RpcViews.registerServerGrpcViews(viewManager);
    }

    public static void registerClientGrpcViews() {
        RpcViews.registerClientGrpcViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerClientGrpcViews(ViewManager viewManager) {
        for (View view : GRPC_CLIENT_VIEWS_SET) {
            viewManager.registerView(view);
        }
    }

    public static void registerServerGrpcViews() {
        RpcViews.registerServerGrpcViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerServerGrpcViews(ViewManager viewManager) {
        for (View view : GRPC_SERVER_VIEWS_SET) {
            viewManager.registerView(view);
        }
    }

    public static void registerAllGrpcBasicViews() {
        RpcViews.registerAllGrpcBasicViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerAllGrpcBasicViews(ViewManager viewManager) {
        RpcViews.registerClientGrpcBasicViews(viewManager);
        RpcViews.registerServerGrpcBasicViews(viewManager);
    }

    public static void registerClientGrpcBasicViews() {
        RpcViews.registerClientGrpcBasicViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerClientGrpcBasicViews(ViewManager viewManager) {
        for (View view : GRPC_CLIENT_BASIC_VIEWS_SET) {
            viewManager.registerView(view);
        }
    }

    public static void registerServerGrpcBasicViews() {
        RpcViews.registerServerGrpcBasicViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerServerGrpcBasicViews(ViewManager viewManager) {
        for (View view : GRPC_SERVER_BASIC_VIEWS_SET) {
            viewManager.registerView(view);
        }
    }

    @Deprecated
    public static void registerAllCumulativeViews() {
        RpcViews.registerAllCumulativeViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerAllCumulativeViews(ViewManager viewManager) {
        for (View view : RPC_CUMULATIVE_VIEWS_SET) {
            viewManager.registerView(view);
        }
    }

    @Deprecated
    public static void registerAllIntervalViews() {
        RpcViews.registerAllIntervalViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerAllIntervalViews(ViewManager viewManager) {
        for (View view : RPC_INTERVAL_VIEWS_SET) {
            viewManager.registerView(view);
        }
    }

    @Deprecated
    public static void registerAllViews() {
        RpcViews.registerAllViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerAllViews(ViewManager viewManager) {
        RpcViews.registerAllCumulativeViews(viewManager);
        RpcViews.registerAllIntervalViews(viewManager);
    }

    public static void registerRealTimeMetricsViews() {
        RpcViews.registerRealTimeMetricsViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerRealTimeMetricsViews(ViewManager viewManager) {
        for (View view : GRPC_REAL_TIME_METRICS_VIEWS_SET) {
            viewManager.registerView(view);
        }
    }

    private RpcViews() {
    }
}

