/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.runtime;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.submarine.commons.runtime.RuntimeFactory;
import org.apache.submarine.commons.runtime.fs.DefaultRemoteDirectoryManager;
import org.apache.submarine.commons.runtime.fs.RemoteDirectoryManager;
import org.apache.submarine.commons.utils.SubmarineConfiguration;

public class ClientContext {
    private Configuration yarnConf = new YarnConfiguration();
    private volatile RemoteDirectoryManager remoteDirectoryManager;
    private YarnClient yarnClient;
    private SubmarineConfiguration submarineConfig = SubmarineConfiguration.getInstance();
    private RuntimeFactory runtimeFactory;

    public synchronized YarnClient getOrCreateYarnClient() {
        if (this.yarnClient == null) {
            this.yarnClient = YarnClient.createYarnClient();
            this.yarnClient.init(this.yarnConf);
            this.yarnClient.start();
        }
        return this.yarnClient;
    }

    public Configuration getYarnConfig() {
        return this.yarnConf;
    }

    public void setYarnConfig(Configuration conf) {
        this.yarnConf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteDirectoryManager getRemoteDirectoryManager() {
        if (this.remoteDirectoryManager == null) {
            ClientContext clientContext = this;
            synchronized (clientContext) {
                if (this.remoteDirectoryManager == null) {
                    this.remoteDirectoryManager = new DefaultRemoteDirectoryManager(this);
                }
            }
        }
        return this.remoteDirectoryManager;
    }

    public SubmarineConfiguration getSubmarineConfig() {
        return this.submarineConfig;
    }

    public void setSubmarineConfig(SubmarineConfiguration submarineConfig) {
        this.submarineConfig = submarineConfig;
    }

    public RuntimeFactory getRuntimeFactory() {
        return this.runtimeFactory;
    }

    public void setRuntimeFactory(RuntimeFactory runtimeFactory) {
        this.runtimeFactory = runtimeFactory;
    }
}

