/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.runtime.api;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;

public enum Runtime {
    TONY("tony"),
    YARN_SERVICE("yarnservice");

    private String value;

    private Runtime(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Runtime parseByValue(String value) {
        for (Runtime rt : Runtime.values()) {
            if (!rt.value.equalsIgnoreCase(value)) continue;
            return rt;
        }
        return null;
    }

    public static String getValues() {
        List values = Lists.newArrayList((Object[])Runtime.values()).stream().map(rt -> rt.value).collect(Collectors.toList());
        return String.join((CharSequence)",", values);
    }

    public static class Constants {
        public static final String TONY = "tony";
        public static final String YARN_SERVICE = "yarnservice";
    }
}

