/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.runtime.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.submarine.commons.runtime.ClientContext;
import org.apache.submarine.commons.runtime.fs.RemoteDirectoryManager;
import org.apache.submarine.commons.runtime.fs.SubmarineStorage;

public class FSBasedSubmarineStorageImpl
extends SubmarineStorage {
    RemoteDirectoryManager rdm;

    public FSBasedSubmarineStorageImpl(ClientContext clientContext) {
        this.rdm = clientContext.getRemoteDirectoryManager();
    }

    @Override
    public void addNewJob(String jobName, Map<String, String> jobInfo) throws IOException {
        Path jobInfoPath = this.getJobInfoPath(jobName, true);
        FSDataOutputStream fos = this.rdm.getDefaultFileSystem().create(jobInfoPath);
        this.serializeMap(fos, jobInfo);
    }

    @Override
    public Map<String, String> getJobInfoByName(String jobName) throws IOException {
        Path jobInfoPath = this.getJobInfoPath(jobName, false);
        FSDataInputStream fis = this.rdm.getDefaultFileSystem().open(jobInfoPath);
        return this.deserializeMap(fis);
    }

    @Override
    public void addNewModel(String modelName, String version, Map<String, String> modelInfo) throws IOException {
        Path modelInfoPath = this.getModelInfoPath(modelName, version, true);
        FSDataOutputStream fos = this.rdm.getDefaultFileSystem().create(modelInfoPath);
        this.serializeMap(fos, modelInfo);
    }

    @Override
    public Map<String, String> getModelInfoByName(String modelName, String version) throws IOException {
        Path modelInfoPath = this.getModelInfoPath(modelName, version, false);
        FSDataInputStream fis = this.rdm.getDefaultFileSystem().open(modelInfoPath);
        return this.deserializeMap(fis);
    }

    private Path getModelInfoPath(String modelName, String version, boolean create) throws IOException {
        Path modelDir = this.rdm.getModelDir(modelName, create);
        return new Path(modelDir, version + ".info");
    }

    private void serializeMap(FSDataOutputStream fos, Map<String, String> map) throws IOException {
        ObjectOutputStream oo = new ObjectOutputStream((OutputStream)fos);
        oo.writeObject(map);
        oo.close();
    }

    private Map<String, String> deserializeMap(FSDataInputStream fis) throws IOException {
        Map newMap;
        ObjectInputStream oi = new ObjectInputStream((InputStream)fis);
        try {
            newMap = (Map)oi.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        return newMap;
    }

    private Path getJobInfoPath(String jobName, boolean create) throws IOException {
        Path path = this.rdm.getJobStagingArea(jobName, create);
        return new Path(path, "job.info");
    }
}

