/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.runtime.fs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.submarine.commons.runtime.fs.SubmarineStorage;

public class MemorySubmarineStorage
extends SubmarineStorage {
    private Map<String, Map<String, String>> jobsInfo = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, Map<String, String>>> modelsInfo = new HashMap<String, Map<String, Map<String, String>>>();

    @Override
    public synchronized void addNewJob(String jobName, Map<String, String> jobInfo) throws IOException {
        this.jobsInfo.put(jobName, jobInfo);
    }

    @Override
    public synchronized Map<String, String> getJobInfoByName(String jobName) throws IOException {
        Map<String, String> info = this.jobsInfo.get(jobName);
        if (info == null) {
            throw new IOException("Failed to find job=" + jobName);
        }
        return info;
    }

    @Override
    public synchronized void addNewModel(String modelName, String version, Map<String, String> modelInfo) throws IOException {
        if (!this.modelsInfo.containsKey(modelName)) {
            this.modelsInfo.put(modelName, new HashMap());
        }
        this.modelsInfo.get(modelName).put(version, modelInfo);
    }

    @Override
    public synchronized Map<String, String> getModelInfoByName(String modelName, String version) throws IOException {
        boolean notFound = false;
        Map<String, String> info = null;
        try {
            info = this.modelsInfo.get(modelName).get(version);
        }
        catch (NullPointerException e) {
            notFound = true;
        }
        if (notFound || info == null) {
            throw new IOException("Failed to find, model=" + modelName + " version=" + version);
        }
        return info;
    }
}

