/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmarineConfVars {
    private static final Logger LOG = LoggerFactory.getLogger(SubmarineConfVars.class);

    public static enum ConfVars {
        SUBMARINE_CONF_DIR("submarine.conf.dir", "conf"),
        SUBMARINE_LOCALIZATION_MAX_ALLOWED_FILE_SIZE_MB("submarine.localization.max-allowed-file-size-mb", 2048L),
        SUBMARINE_SERVER_ADDR("submarine.server.addr", "0.0.0.0"),
        SUBMARINE_SERVER_PORT("submarine.server.port", 8080),
        SUBMARINE_SERVER_SSL("submarine.server.ssl", false),
        SUBMARINE_SERVER_SSL_PORT("submarine.server.ssl.port", 8443),
        SUBMARINE_SERVER_JETTY_THREAD_POOL_MAX("submarine.server.jetty.thread.pool.max", 400),
        SUBMARINE_SERVER_JETTY_THREAD_POOL_MIN("submarine.server.jetty.thread.pool.min", 8),
        SUBMARINE_SERVER_JETTY_THREAD_POOL_TIMEOUT("submarine.server.jetty.thread.pool.timeout", 30),
        SUBMARINE_SERVER_JETTY_REQUEST_HEADER_SIZE("submarine.server.jetty.request.header.size", 8192),
        SUBMARINE_SERVER_SSL_CLIENT_AUTH("submarine.server.ssl.client.auth", false),
        SUBMARINE_SERVER_SSL_KEYSTORE_PATH("submarine.server.ssl.keystore.path", "keystore"),
        SUBMARINE_SERVER_SSL_KEYSTORE_TYPE("submarine.server.ssl.keystore.type", "JKS"),
        SUBMARINE_SERVER_SSL_KEYSTORE_PASSWORD("submarine.server.ssl.keystore.password", ""),
        SUBMARINE_SERVER_SSL_KEY_MANAGER_PASSWORD("submarine.server.ssl.key.manager.password", null),
        SUBMARINE_SERVER_SSL_TRUSTSTORE_PATH("submarine.server.ssl.truststore.path", null),
        SUBMARINE_SERVER_SSL_TRUSTSTORE_TYPE("submarine.server.ssl.truststore.type", null),
        SUBMARINE_SERVER_SSL_TRUSTSTORE_PASSWORD("submarine.server.ssl.truststore.password", null),
        SUBMARINE_CLUSTER_ADDR("submarine.cluster.addr", ""),
        SUBMARINE_SERVER_RPC_ENABLED("submarine.server.rpc.enabled", false),
        SUBMARINE_SERVER_RPC_PORT("submarine.server.rpc.port", 8980),
        CLUSTER_HEARTBEAT_INTERVAL("cluster.heartbeat.interval", 3000),
        CLUSTER_HEARTBEAT_TIMEOUT("cluster.heartbeat.timeout", 9000),
        JDBC_DRIVERCLASSNAME("jdbc.driverClassName", "com.mysql.jdbc.Driver"),
        JDBC_URL("jdbc.url", "jdbc:mysql://127.0.0.1:3306/submarine?useUnicode=true&characterEncoding=UTF-8&autoReconnect=true&failOverReadOnly=false&zeroDateTimeBehavior=convertToNull&useSSL=false"),
        JDBC_USERNAME("jdbc.username", "submarine"),
        JDBC_PASSWORD("jdbc.password", "password"),
        METASTORE_JDBC_URL("metastore.jdbc.url", "jdbc:mysql://127.0.0.1:3306/metastore?useUnicode=true&characterEncoding=UTF-8&autoReconnect=true&failOverReadOnly=false&zeroDateTimeBehavior=convertToNull&useSSL=false"),
        METASTORE_JDBC_USERNAME("metastore.jdbc.username", "metastore"),
        METASTORE_JDBC_PASSWORD("metastore.jdbc.password", "password"),
        WORKBENCH_WEBSOCKET_MAX_TEXT_MESSAGE_SIZE("workbench.websocket.max.text.message.size", "1024000"),
        WORKBENCH_WEB_WAR("workbench.web.war", "submarine-workbench/workbench-web/dist"),
        SUBMARINE_RUNTIME_CLASS("submarine.runtime.class", "org.apache.submarine.server.submitter.yarn.YarnRuntimeFactory"),
        SUBMARINE_SUBMITTER("submarine.submitter", "k8s"),
        ENVIRONMENT_CONDA_MIN_VERSION("environment.conda.min.version", "4.0.1"),
        ENVIRONMENT_CONDA_MAX_VERSION("environment.conda.max.version", "4.10.10");

        private String varName;
        private Class varClass;
        private String stringValue;
        private VarType type;
        private int intValue;
        private float floatValue;
        private boolean booleanValue;
        private long longValue;

        private ConfVars(String varName, String varValue) {
            this.varName = varName;
            this.varClass = String.class;
            this.stringValue = varValue;
            this.intValue = -1;
            this.floatValue = -1.0f;
            this.longValue = -1L;
            this.booleanValue = false;
            this.type = VarType.STRING;
        }

        private ConfVars(String varName, int intValue) {
            this.varName = varName;
            this.varClass = Integer.class;
            this.stringValue = null;
            this.intValue = intValue;
            this.floatValue = -1.0f;
            this.longValue = -1L;
            this.booleanValue = false;
            this.type = VarType.INT;
        }

        private ConfVars(String varName, long longValue) {
            this.varName = varName;
            this.varClass = Integer.class;
            this.stringValue = null;
            this.intValue = -1;
            this.floatValue = -1.0f;
            this.longValue = longValue;
            this.booleanValue = false;
            this.type = VarType.LONG;
        }

        private ConfVars(String varName, float floatValue) {
            this.varName = varName;
            this.varClass = Float.class;
            this.stringValue = null;
            this.intValue = -1;
            this.longValue = -1L;
            this.floatValue = floatValue;
            this.booleanValue = false;
            this.type = VarType.FLOAT;
        }

        private ConfVars(String varName, boolean booleanValue) {
            this.varName = varName;
            this.varClass = Boolean.class;
            this.stringValue = null;
            this.intValue = -1;
            this.longValue = -1L;
            this.floatValue = -1.0f;
            this.booleanValue = booleanValue;
            this.type = VarType.BOOLEAN;
        }

        public String getVarName() {
            return this.varName;
        }

        public Class getVarClass() {
            return this.varClass;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public long getLongValue() {
            return this.longValue;
        }

        public float getFloatValue() {
            return this.floatValue;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }

        public VarType getType() {
            return this.type;
        }

        static enum VarType {
            STRING{

                @Override
                void checkType(String value) throws Exception {
                }
            }
            ,
            INT{

                @Override
                void checkType(String value) throws Exception {
                    Integer.valueOf(value);
                }
            }
            ,
            LONG{

                @Override
                void checkType(String value) throws Exception {
                    Long.valueOf(value);
                }
            }
            ,
            FLOAT{

                @Override
                void checkType(String value) throws Exception {
                    Float.valueOf(value);
                }
            }
            ,
            BOOLEAN{

                @Override
                void checkType(String value) throws Exception {
                    Boolean.valueOf(value);
                }
            };


            boolean isType(String value) {
                try {
                    this.checkType(value);
                }
                catch (Exception e) {
                    LOG.error("Exception in SubmarineConfiguration while isType", (Throwable)e);
                    return false;
                }
                return true;
            }

            String typeString() {
                return this.name().toUpperCase();
            }

            abstract void checkType(String var1) throws Exception;
        }
    }
}

