/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.server.api.environment;

import org.apache.submarine.commons.utils.AbstractUniqueIdGenerator;

public class EnvironmentId
extends AbstractUniqueIdGenerator<EnvironmentId> {
    private static final String ENVIRONMENT_ID_PREFIX = "environment_";

    public static EnvironmentId fromString(String environmentId) {
        if (environmentId == null) {
            return null;
        }
        String[] components = environmentId.split("\\_");
        if (components.length != 3) {
            return null;
        }
        return EnvironmentId.newInstance(Long.parseLong(components[1]), Integer.parseInt(components[2]));
    }

    public static EnvironmentId newInstance(long serverTimestamp, int id) {
        EnvironmentId experimentId = new EnvironmentId();
        experimentId.setServerTimestamp(serverTimestamp);
        experimentId.setId(id);
        return experimentId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(ENVIRONMENT_ID_PREFIX).append(this.getServerTimestamp()).append("_");
        this.format(sb, this.getId());
        return sb.toString();
    }
}

